/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.registry.AttributeAccess;
import org.shaded.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class ReadAttributeGroupNamesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute-group-names", ControllerResolver.getResolver("global")).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static OperationStepHandler INSTANCE = new ReadAttributeGroupNamesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult().setEmptyList();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Set<String> attributeNames = registry != null ? registry.getAttributeNames(PathAddress.EMPTY_ADDRESS) : Collections.emptySet();
        TreeSet<String> groupNames = new TreeSet<String>();
        for (String attributeName : attributeNames) {
            AttributeAccess attribute = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (attribute.getAttributeDefinition().getAttributeGroup() == null) continue;
            groupNames.add(attribute.getAttributeDefinition().getAttributeGroup());
        }
        for (String groupName : groupNames) {
            result.add(groupName);
        }
    }
}

