/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.global;

import java.util.Set;
import java.util.TreeSet;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.descriptions.common.ControllerResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.shaded.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class ReadChildrenTypesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-types", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.INCLUDE_ALIASES, GlobalOperationAttributes.INCLUDE_SINGLETONS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationStepHandler INSTANCE = new ReadChildrenTypesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(context.getCurrentAddress()));
        }
        boolean aliases = GlobalOperationAttributes.INCLUDE_ALIASES.resolveModelAttribute(context, operation).asBoolean(false);
        boolean singletons = GlobalOperationAttributes.INCLUDE_SINGLETONS.resolveModelAttribute(context, operation).asBoolean(false);
        Set<PathElement> childTypes = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        TreeSet<String> children = new TreeSet<String>();
        for (PathElement child : childTypes) {
            boolean isSingletonResource;
            PathAddress relativeAddr = PathAddress.pathAddress(child);
            ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
            boolean bl = isSingletonResource = childReg == null || !child.isWildcard();
            if (childReg.isAlias() && !aliases) continue;
            if (singletons && isSingletonResource) {
                children.add(child.getKey() + '=' + child.getValue());
                continue;
            }
            children.add(child.getKey());
        }
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String child : children) {
            result.add(child);
        }
    }
}

