/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.operations.validation;

import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.shaded.jboss.as.controller.operations.validation.ParameterValidator;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class PropertyValidator
extends ModelTypeValidator {
    private final ParameterValidator valueValidator;

    public PropertyValidator(boolean nullable, ParameterValidator valueValidator) {
        super(ModelType.PROPERTY, nullable);
        this.valueValidator = valueValidator;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            if (value.asProperty().getName().length() < 1) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinLength(value.asProperty().getName(), parameterName, 1));
            }
            if (this.valueValidator != null) {
                this.valueValidator.validateParameter(parameterName, value.asProperty().getValue());
            }
        }
    }
}

