/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.registry;

import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.registry.ManagementResourceRegistration;
import org.shaded.jboss.as.controller.registry.PlaceholderResource;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.as.controller.transform.TransformationContext;
import org.shaded.jboss.as.controller.transform.Transformers;
import org.shaded.jboss.dmr.ModelNode;

public abstract class AliasEntry {
    private final ManagementResourceRegistration target;
    private volatile PathAddress aliasAddress;
    private volatile PathAddress targetAddress;

    protected AliasEntry(ManagementResourceRegistration target) {
        this.target = target;
    }

    ManagementResourceRegistration getTarget() {
        return this.target;
    }

    void setAddresses(PathAddress targetAddress, PathAddress aliasAddress) {
        this.targetAddress = targetAddress;
        this.aliasAddress = aliasAddress;
    }

    protected PathAddress getAliasAddress() {
        return this.aliasAddress;
    }

    protected PathAddress getTargetAddress() {
        return this.targetAddress;
    }

    @Deprecated
    public PathAddress convertToTargetAddress(PathAddress aliasAddress) {
        throw new UnsupportedOperationException("convertToTargetAddress");
    }

    public PathAddress convertToTargetAddress(PathAddress aliasAddress, AliasContext aliasContext) {
        return this.convertToTargetAddress(aliasAddress);
    }

    private static interface ResourceProvider {
        public Resource readResourceFromRoot(PathAddress var1);

        public Resource readResourceFromRoot(PathAddress var1, boolean var2);
    }

    public static class AliasContext {
        public static final String RECURSIVE_GLOBAL_OP = "recursive-global-op";
        final ResourceProvider delegate;
        final ModelNode operation;

        private AliasContext(ModelNode operation, ResourceProvider delegate) {
            this.delegate = delegate;
            this.operation = operation.clone();
            this.operation.protect();
        }

        static AliasContext create(ModelNode operation, final OperationContext delegate) {
            return new AliasContext(operation, new ResourceProvider(){

                @Override
                public Resource readResourceFromRoot(PathAddress address) {
                    return delegate.readResourceFromRoot(address);
                }

                @Override
                public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
                    return delegate.readResourceFromRoot(address, recursive);
                }
            });
        }

        public static AliasContext create(PathAddress address, OperationContext delegate) {
            return AliasContext.create(Util.createEmptyOperation(RECURSIVE_GLOBAL_OP, address), delegate);
        }

        public static AliasContext create(ModelNode operation, final TransformationContext delegate) {
            return new AliasContext(operation, new ResourceProvider(){

                @Override
                public Resource readResourceFromRoot(PathAddress address) {
                    return delegate.readResourceFromRoot(address);
                }

                @Override
                public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
                    return delegate.readResourceFromRoot(address);
                }
            });
        }

        public static AliasContext create(ModelNode operation, final Transformers.TransformationInputs transformationInputs) {
            return new AliasContext(operation, new ResourceProvider(){

                @Override
                public Resource readResourceFromRoot(PathAddress address) {
                    return this.readResourceFromRoot(address, false);
                }

                @Override
                public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
                    Resource resource = transformationInputs.getRootResource().navigate(address);
                    if (resource == null) {
                        return resource;
                    }
                    if (recursive) {
                        return resource.clone();
                    }
                    Resource copy = Resource.Factory.create();
                    copy.writeModel(resource.getModel());
                    for (String childType : resource.getChildTypes()) {
                        for (Resource.ResourceEntry child : resource.getChildren(childType)) {
                            copy.registerChild(child.getPathElement(), PlaceholderResource.INSTANCE);
                        }
                    }
                    return copy;
                }
            });
        }

        public Resource readResourceFromRoot(PathAddress address) {
            return this.delegate.readResourceFromRoot(address);
        }

        public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
            return this.delegate.readResourceFromRoot(address, recursive);
        }

        public ModelNode getOperation() {
            return this.operation;
        }
    }
}

