/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.registry;

import java.util.List;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.registry.AliasEntry;
import org.shaded.jboss.as.controller.registry.WildcardReadResourceDescriptionAddressHack;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class AliasStepHandler
implements OperationStepHandler {
    private final AliasEntry aliasEntry;

    AliasStepHandler(AliasEntry aliasEntry) {
        this.aliasEntry = aliasEntry;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String op = operation.require("operation").asString();
        PathAddress addr = context.getCurrentAddress();
        WildcardReadResourceDescriptionAddressHack.attachAliasAddress(context, operation);
        AliasEntry.AliasContext aliasContext = AliasEntry.AliasContext.create(operation, context);
        PathAddress mapped = this.aliasEntry.convertToTargetAddress(addr, aliasContext);
        assert (!addr.equals(mapped)) : "Alias was not translated";
        OperationStepHandler targetHandler = context.getRootResourceRegistration().getOperationHandler(mapped, op);
        if (targetHandler == null) {
            throw ControllerLogger.ROOT_LOGGER.aliasStepHandlerOperationNotFound(op, addr, mapped);
        }
        ModelNode copy = operation.clone();
        copy.get("address").set(mapped.toModelNode());
        context.addStep(copy, targetHandler, OperationContext.Stage.MODEL, true);
        if (this.isTrimReadResourceDefinitionArray(op, addr, mapped)) {
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    List<ModelNode> list;
                    ModelNode result = context.getResult();
                    if (result.getType() == ModelType.LIST && (list = result.asList()).size() == 1) {
                        ModelNode entry = list.get(0);
                        context.getResult().set(entry.get("result"));
                    }
                }
            });
        }
    }

    private boolean isTrimReadResourceDefinitionArray(String opName, PathAddress aliasAddr, PathAddress targetAddr) {
        if (!opName.equals("read-resource-description")) {
            return false;
        }
        if (aliasAddr.isMultiTarget()) {
            return false;
        }
        return targetAddr.isMultiTarget();
    }
}

