/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.remote;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.shaded.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    SecurityActions() {
    }

    static Subject getSubject() {
        AccessControlContext acc = AccessController.getContext();
        return SecurityActions.getSubjectAction().getSubject(acc);
    }

    private static GetSubjectAction getSubjectAction() {
        return WildFlySecurityManager.isChecking() ? GetSubjectAction.PRIVILEGED : GetSubjectAction.NON_PRIVILEGED;
    }

    private static interface GetSubjectAction {
        public static final GetSubjectAction NON_PRIVILEGED = new GetSubjectAction(){

            @Override
            public Subject getSubject(AccessControlContext acc) {
                return Subject.getSubject(acc);
            }
        };
        public static final GetSubjectAction PRIVILEGED = new GetSubjectAction(){

            @Override
            public Subject getSubject(final AccessControlContext acc) {
                return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return NON_PRIVILEGED.getSubject(acc);
                    }
                });
            }
        };

        public Subject getSubject(AccessControlContext var1);
    }
}

