/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.services.path;

import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.as.controller.services.path.PathAddHandler;
import org.shaded.jboss.as.controller.services.path.PathManager;
import org.shaded.jboss.as.controller.services.path.PathManagerService;
import org.shaded.jboss.as.controller.services.path.PathResourceDefinition;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.msc.service.ServiceTarget;

public class PathRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final boolean services;
    private final PathManagerService pathManager;

    protected PathRemoveHandler(PathManagerService pathManager, boolean services) {
        this.pathManager = pathManager;
        this.services = services;
    }

    static PathRemoveHandler createNamedInstance(PathManagerService pathManager) {
        return new PathRemoveHandler(pathManager, false);
    }

    static PathRemoveHandler createSpecifiedInstance(PathManagerService pathManager) {
        return new PathRemoveHandler(pathManager, true);
    }

    static PathRemoveHandler createSpecifiedNoServicesInstance(PathManagerService pathManager) {
        return new PathRemoveHandler(pathManager, false);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        final ModelNode model = Resource.Tools.readModel(context.readResource(PathAddress.EMPTY_ADDRESS));
        if (model.get(PathResourceDefinition.READ_ONLY.getName()).asBoolean(false)) {
            throw ControllerLogger.ROOT_LOGGER.cannotRemoveReadOnlyPath(name);
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (this.services) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final PathManagerService.PathEventContextImpl pathEventContext = PathRemoveHandler.this.pathManager.checkRestartRequired(context, name, PathManager.Event.REMOVED);
                    if (pathEventContext.isInstallServices()) {
                        PathRemoveHandler.this.pathManager.removePathEntry(name, true);
                        PathRemoveHandler.this.pathManager.removePathService(context, name);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            try {
                                String path = PathAddHandler.getPathValue(context, PathResourceDefinition.PATH_SPECIFIED, model);
                                String relativeTo = PathAddHandler.getPathValue(context, PathResourceDefinition.RELATIVE_TO, model);
                                if (pathEventContext.isInstallServices()) {
                                    PathRemoveHandler.this.pathManager.addPathEntry(name, path, relativeTo, false);
                                    ServiceTarget target = context.getServiceTarget();
                                    if (relativeTo == null) {
                                        PathRemoveHandler.this.pathManager.addAbsolutePathService(target, name, path);
                                    } else {
                                        PathRemoveHandler.this.pathManager.addRelativePathService(target, name, path, false, relativeTo);
                                    }
                                } else {
                                    context.revertRestartRequired();
                                }
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress(operation.get("address")));
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

