/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.shaded.jboss.as.controller.AttributeDefinition;
import org.shaded.jboss.as.controller.ModelVersion;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.as.controller.transform.AttributeTransformationRequirementChecker;
import org.shaded.jboss.as.controller.transform.OperationRejectionPolicy;
import org.shaded.jboss.as.controller.transform.OperationResultTransformer;
import org.shaded.jboss.as.controller.transform.OperationTransformer;
import org.shaded.jboss.as.controller.transform.ResourceTransformationContext;
import org.shaded.jboss.as.controller.transform.ResourceTransformer;
import org.shaded.jboss.as.controller.transform.TransformationContext;
import org.shaded.jboss.as.controller.transform.TransformationTarget;
import org.shaded.jboss.dmr.ModelNode;

public class RejectExpressionValuesTransformer
implements ResourceTransformer,
OperationTransformer {
    private final Set<String> attributeNames;
    private final Map<String, AttributeTransformationRequirementChecker> attributeCheckers;
    private final OperationTransformer writeAttributeTransformer = new WriteAttributeTransformer();

    public RejectExpressionValuesTransformer(AttributeDefinition ... attributes) {
        this(RejectExpressionValuesTransformer.namesFromDefinitions(attributes));
    }

    private static Set<String> namesFromDefinitions(AttributeDefinition ... attributes) {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition def : attributes) {
            names.add(def.getName());
        }
        return names;
    }

    public RejectExpressionValuesTransformer(Set<String> attributeNames) {
        this(attributeNames, null);
    }

    public RejectExpressionValuesTransformer(String ... attributeNames) {
        this(new HashSet<String>(Arrays.asList(attributeNames)));
    }

    public RejectExpressionValuesTransformer(Set<String> allAttributeNames, Map<String, AttributeTransformationRequirementChecker> specialCheckers) {
        this.attributeNames = allAttributeNames;
        this.attributeCheckers = specialCheckers;
    }

    public RejectExpressionValuesTransformer(Map<String, AttributeTransformationRequirementChecker> specialCheckers) {
        this(specialCheckers.keySet(), specialCheckers);
    }

    public RejectExpressionValuesTransformer(String attributeName, AttributeTransformationRequirementChecker checker) {
        this(Collections.singletonMap(attributeName, checker));
    }

    public OperationTransformer getWriteAttributeTransformer() {
        return this.writeAttributeTransformer;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
        final Set<String> attributes = this.checkModel(operation, context);
        boolean reject = attributes.size() > 0;
        OperationRejectionPolicy rejectPolicy = reject ? new OperationRejectionPolicy(){

            @Override
            public boolean rejectOperation(ModelNode preparedResult) {
                return true;
            }

            @Override
            public String getFailureDescription() {
                return context.getLogger().getAttributeWarning(address, operation, ControllerLogger.ROOT_LOGGER.attributesDontSupportExpressions(), attributes);
            }
        } : OperationTransformer.DEFAULT_REJECTION_POLICY;
        return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        Set<String> attributes = this.checkModel(model, context);
        if (attributes.size() > 0) {
            if (context.getTarget().isIgnoredResourceListAvailableAtRegistration()) {
                ModelVersion usedVersion;
                List<String> msg = Collections.singletonList(context.getLogger().getAttributeWarning(address, null, ControllerLogger.ROOT_LOGGER.attributesDontSupportExpressions(), attributes));
                TransformationTarget tgt = context.getTarget();
                String legacyHostName = tgt.getHostName();
                ModelVersion coreVersion = tgt.getVersion();
                String subsystemName = RejectExpressionValuesTransformer.findSubsystemName(address);
                ModelVersion modelVersion = usedVersion = subsystemName == null ? coreVersion : tgt.getSubsystemVersion(subsystemName);
                if (subsystemName != null) {
                    throw ControllerLogger.ROOT_LOGGER.rejectAttributesSubsystemModelResourceTransformer(address, legacyHostName, subsystemName, usedVersion, msg);
                }
                throw ControllerLogger.ROOT_LOGGER.rejectAttributesCoreModelResourceTransformer(address, legacyHostName, usedVersion, msg);
            }
            context.getLogger().logAttributeWarning(address, ControllerLogger.ROOT_LOGGER.attributesDontSupportExpressions(), attributes);
        }
        ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        childContext.processChildren(resource);
    }

    private static String findSubsystemName(PathAddress pathAddress) {
        for (PathElement element : pathAddress) {
            if (!element.getKey().equals("subsystem")) continue;
            return element.getValue();
        }
        return null;
    }

    private Set<String> checkModel(ModelNode model, TransformationContext context) throws OperationFailedException {
        HashSet<String> attributes = new HashSet<String>();
        for (String attribute : this.attributeNames) {
            AttributeTransformationRequirementChecker checker;
            if (!model.hasDefined(attribute)) continue;
            if (this.attributeCheckers != null && (checker = this.attributeCheckers.get(attribute)) != null) {
                if (!checker.isAttributeTransformationRequired(attribute, model.get(attribute), context)) continue;
                attributes.add(attribute);
                continue;
            }
            if (!AttributeTransformationRequirementChecker.SIMPLE_EXPRESSIONS.isAttributeTransformationRequired(attribute, model.get(attribute), context)) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    class WriteAttributeTransformer
    implements OperationTransformer {
        WriteAttributeTransformer() {
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            boolean rejectResult;
            final String attribute = operation.require("name").asString();
            boolean containsExpression = false;
            if (RejectExpressionValuesTransformer.this.attributeNames.contains(attribute) && operation.hasDefined("value")) {
                AttributeTransformationRequirementChecker checker;
                if (RejectExpressionValuesTransformer.this.attributeCheckers != null && (checker = (AttributeTransformationRequirementChecker)RejectExpressionValuesTransformer.this.attributeCheckers.get(attribute)) != null) {
                    if (checker.isAttributeTransformationRequired(attribute, operation.get("value"), context)) {
                        containsExpression = true;
                    }
                } else if (AttributeTransformationRequirementChecker.SIMPLE_EXPRESSIONS.isAttributeTransformationRequired(attribute, operation.get("value"), context)) {
                    containsExpression = true;
                }
            }
            if (rejectResult = containsExpression) {
                OperationRejectionPolicy rejectPolicy = new OperationRejectionPolicy(){

                    @Override
                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    @Override
                    public String getFailureDescription() {
                        return context.getLogger().getAttributeWarning(address, operation, new String[]{ControllerLogger.ROOT_LOGGER.attributesDontSupportExpressions(), attribute});
                    }
                };
                return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

