/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules;

import java.io.File;
import java.security.AccessController;
import java.util.jar.JarFile;
import org.shaded.jboss.modules.FileResourceLoader;
import org.shaded.jboss.modules.FilteredIterableResourceLoader;
import org.shaded.jboss.modules.FilteredResourceLoader;
import org.shaded.jboss.modules.IterableResourceLoader;
import org.shaded.jboss.modules.JarFileResourceLoader;
import org.shaded.jboss.modules.PropertyReadAction;
import org.shaded.jboss.modules.ResourceLoader;
import org.shaded.jboss.modules.filter.PathFilter;

public final class ResourceLoaders {
    static final boolean USE_INDEXES = Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.use-indexes", "false")));
    static final boolean WRITE_INDEXES = USE_INDEXES && Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.write-indexes", "false")));

    private ResourceLoaders() {
    }

    public static ResourceLoader createFileResourceLoader(String name, File root) {
        return new FileResourceLoader(name, root, AccessController.getContext());
    }

    public static IterableResourceLoader createIterableFileResourceLoader(String name, File root) {
        return new FileResourceLoader(name, root, AccessController.getContext());
    }

    public static ResourceLoader createJarResourceLoader(String name, JarFile jarFile) {
        return new JarFileResourceLoader(name, jarFile);
    }

    public static IterableResourceLoader createJarResourceLoader(String name, JarFile jarFile, String relativePath) {
        return new JarFileResourceLoader(name, jarFile, relativePath);
    }

    public static IterableResourceLoader createIterableJarResourceLoader(String name, JarFile jarFile) {
        return new JarFileResourceLoader(name, jarFile);
    }

    public static ResourceLoader createFilteredResourceLoader(PathFilter pathFilter, ResourceLoader originalLoader) {
        return new FilteredResourceLoader(pathFilter, originalLoader);
    }

    public static IterableResourceLoader createIterableFilteredResourceLoader(PathFilter pathFilter, IterableResourceLoader originalLoader) {
        return new FilteredIterableResourceLoader(pathFilter, originalLoader);
    }
}

