/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules.filter;

import java.util.Iterator;
import java.util.Set;
import org.shaded.jboss.modules.filter.PathFilter;

final class SetPathFilter
implements PathFilter {
    private final Set<String> paths;
    private final int hashCode;

    SetPathFilter(Set<String> paths) {
        this.paths = paths;
        this.hashCode = paths.hashCode();
    }

    @Override
    public boolean accept(String path) {
        return this.paths.contains(path);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("in {");
        Iterator<String> iterator = this.paths.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            b.append(path);
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        b.append('}');
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SetPathFilter && this.equals((SetPathFilter)obj);
    }

    public boolean equals(SetPathFilter obj) {
        return obj != null && obj.paths.equals(this.paths);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

