/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.shaded.jboss.modules.maven.MavenArtifactUtil;
import org.shaded.jboss.modules.xml.MXParser;
import org.shaded.jboss.modules.xml.ModuleXmlParser;
import org.shaded.jboss.modules.xml.XmlPullParser;
import org.shaded.jboss.modules.xml.XmlPullParserException;

final class MavenSettings {
    private static final Object settingLoaderMutex = new Object();
    private static volatile MavenSettings mavenSettings;
    private Path localRepository = null;
    private final List<String> remoteRepositories = new LinkedList<String>();
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final List<String> activeProfileNames = new LinkedList<String>();

    MavenSettings() {
        this.configureDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MavenSettings getSettings() throws IOException {
        if (mavenSettings != null) {
            return mavenSettings;
        }
        Object object = settingLoaderMutex;
        synchronized (object) {
            if (mavenSettings != null) {
                return mavenSettings;
            }
            mavenSettings = MavenArtifactUtil.doIo(() -> {
                String mavenHome;
                MavenSettings settings = new MavenSettings();
                Path m2 = Paths.get(System.getProperty("user.home"), ".m2");
                Path settingsPath = m2.resolve("settings.xml");
                if (Files.notExists(settingsPath, new LinkOption[0]) && (mavenHome = System.getenv("M2_HOME")) != null) {
                    settingsPath = Paths.get(mavenHome, "conf", "settings.xml");
                }
                if (Files.exists(settingsPath, new LinkOption[0])) {
                    MavenSettings.parseSettingsXml(settingsPath, settings);
                }
                if (settings.getLocalRepository() == null) {
                    Path repository = m2.resolve("repository");
                    settings.setLocalRepository(repository);
                }
                settings.resolveActiveSettings();
                return settings;
            });
            return mavenSettings;
        }
    }

    static MavenSettings parseSettingsXml(Path settings, MavenSettings mavenSettings) throws IOException {
        try {
            int eventType;
            MXParser reader = new MXParser();
            reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            InputStream source = Files.newInputStream(settings, StandardOpenOption.READ);
            reader.setInput(source, null);
            while ((eventType = reader.next()) != 1) {
                switch (eventType) {
                    case 2: {
                        switch (reader.getName()) {
                            case "settings": {
                                MavenSettings.parseSettings(reader, mavenSettings);
                            }
                        }
                    }
                }
            }
            return mavenSettings;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Could not parse maven settings.xml");
        }
    }

    static void parseSettings(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        block26: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    switch (reader.getName()) {
                        case "localRepository": {
                            String localRepository = reader.nextText();
                            if (localRepository == null || localRepository.trim().isEmpty()) continue block26;
                            mavenSettings.setLocalRepository(Paths.get(localRepository, new String[0]));
                            continue block26;
                        }
                        case "profiles": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "profile": {
                                        MavenSettings.parseProfile(reader, mavenSettings);
                                    }
                                }
                            }
                            continue block26;
                        }
                        case "activeProfiles": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "activeProfile": {
                                        mavenSettings.addActiveProfile(reader.nextText());
                                    }
                                }
                            }
                            continue block26;
                        }
                    }
                    MavenSettings.skip(reader);
                    continue block26;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    static void parseProfile(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        Profile profile = new Profile();
        block14: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "id": {
                    profile.setId(reader.nextText());
                    continue block14;
                }
                case "repositories": {
                    while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                        switch (reader.getName()) {
                            case "repository": {
                                MavenSettings.parseRepository(reader, profile);
                            }
                        }
                    }
                    continue block14;
                }
            }
            MavenSettings.skip(reader);
        }
        mavenSettings.addProfile(profile);
    }

    static void parseRepository(XmlPullParser reader, Profile profile) throws XmlPullParserException, IOException {
        int eventType;
        block6: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "url": {
                    profile.addRepository(reader.nextText());
                    continue block6;
                }
            }
            MavenSettings.skip(reader);
        }
    }

    static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    void configureDefaults() {
        String remoteRepository;
        this.remoteRepositories.add("https://repo1.maven.org/maven2/");
        String localRepositoryPath = System.getProperty("local.maven.repo.path");
        if (localRepositoryPath != null && !localRepositoryPath.trim().isEmpty()) {
            System.out.println("Please use 'maven.repo.local' instead of 'local.maven.repo.path'");
            this.localRepository = Paths.get(localRepositoryPath.split(File.pathSeparator)[0], new String[0]);
        }
        if ((localRepositoryPath = System.getProperty("maven.repo.local")) != null && !localRepositoryPath.trim().isEmpty()) {
            this.localRepository = Paths.get(localRepositoryPath, new String[0]);
        }
        if ((remoteRepository = System.getProperty("remote.maven.repo")) != null) {
            for (String repo : remoteRepository.split(",")) {
                if (!repo.endsWith("/")) {
                    repo = repo + "/";
                }
                this.remoteRepositories.add(repo);
            }
        }
    }

    public void setLocalRepository(Path localRepository) {
        this.localRepository = localRepository;
    }

    public Path getLocalRepository() {
        return this.localRepository;
    }

    public List<String> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void addProfile(Profile profile) {
        this.profiles.put(profile.getId(), profile);
    }

    public void addActiveProfile(String profileName) {
        this.activeProfileNames.add(profileName);
    }

    void resolveActiveSettings() {
        for (String name : this.activeProfileNames) {
            Profile p = this.profiles.get(name);
            if (p == null) continue;
            this.remoteRepositories.addAll(p.getRepositories());
        }
    }

    static final class Profile {
        private String id;
        final List<String> repositories = new LinkedList<String>();

        Profile() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void addRepository(String url) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            this.repositories.add(url);
        }

        public List<String> getRepositories() {
            return this.repositories;
        }
    }
}

