/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.modules.ref;

import java.lang.ref.ReferenceQueue;
import org.shaded.jboss.modules.ref.Reapable;
import org.shaded.jboss.modules.ref.Reaper;
import org.shaded.jboss.modules.ref.Reference;
import org.shaded.jboss.modules.ref.References;

public class WeakReference<T, A>
extends java.lang.ref.WeakReference<T>
implements Reference<T, A>,
Reapable<T, A> {
    private final A attachment;
    private final Reaper<T, A> reaper;

    public WeakReference(T referent) {
        this(referent, null, (Reaper)null);
    }

    public WeakReference(T referent, A attachment) {
        this(referent, attachment, (Reaper)null);
    }

    public WeakReference(T referent, A attachment, ReferenceQueue<? super T> q) {
        super(referent, q);
        this.attachment = attachment;
        this.reaper = null;
    }

    public WeakReference(T referent, A attachment, Reaper<T, A> reaper) {
        super(referent, References.ReaperThread.REAPER_QUEUE);
        this.attachment = attachment;
        this.reaper = reaper;
    }

    @Override
    public A getAttachment() {
        return this.attachment;
    }

    @Override
    public Reference.Type getType() {
        return Reference.Type.WEAK;
    }

    @Override
    public Reaper<T, A> getReaper() {
        return this.reaper;
    }

    public String toString() {
        return "weak reference to " + String.valueOf(this.get());
    }
}

