/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.inject;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.shaded.jboss.msc.inject.InjectionException;
import org.shaded.jboss.msc.inject.Injector;
import org.shaded.jboss.msc.value.ImmediateValue;
import org.shaded.jboss.msc.value.Value;

public abstract class RetainingInjector<T>
implements Injector<T> {
    private volatile Value<T> value;
    private static final AtomicReferenceFieldUpdater<RetainingInjector, Value> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(RetainingInjector.class, Value.class, "value");

    @Override
    public void inject(T value) throws InjectionException {
        if (!valueUpdater.compareAndSet(this, null, new ImmediateValue<T>(value))) {
            throw new InjectionException("Value already set for this injector");
        }
    }

    @Override
    public void uninject() {
        if (valueUpdater.getAndSet(this, null) == null) {
            // empty if block
        }
    }

    protected Value<T> getStoredValue() {
        return this.value;
    }

    protected Value<T> setStoredValue(Value<T> value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return valueUpdater.getAndSet(this, value);
    }
}

