/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.inject;

import java.lang.reflect.Method;
import org.shaded.jboss.msc.inject.InjectionException;
import org.shaded.jboss.msc.inject.Injector;
import org.shaded.jboss.msc.inject.InjectorLogger;
import org.shaded.jboss.msc.value.Value;

public final class SetMethodInjector<T>
implements Injector<T> {
    private static final Object[] NULL_PARAM = new Object[]{null};
    private final Value<?> target;
    private final Method method;

    public SetMethodInjector(Value<?> target, Method method) {
        this.target = target;
        this.method = method;
    }

    public static <T> Injector<T> create(Value<?> target, Method method) {
        return new SetMethodInjector<T>(target, method);
    }

    @Override
    public void inject(T value) {
        try {
            this.method.invoke(this.target.getValue(), value);
        }
        catch (Exception e) {
            throw new InjectionException("Failed to inject value into method", e);
        }
    }

    @Override
    public void uninject() {
        try {
            this.method.invoke(this.target.getValue(), NULL_PARAM);
        }
        catch (Exception e) {
            InjectorLogger.INSTANCE.uninjectFailed(e, this.method);
        }
    }
}

