/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.msc.value;

import org.shaded.jboss.msc.value.Value;

public final class ThreadLocalValue<T>
implements Value<T> {
    private final ThreadLocal<Value<? extends T>> threadLocal = new ThreadLocal();

    @Override
    public T getValue() {
        Value<T> value = this.threadLocal.get();
        if (value == null) {
            throw new IllegalStateException("No value set");
        }
        return value.getValue();
    }

    public void setValue(Value<? extends T> newValue) {
        this.threadLocal.set(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value<? extends T> getAndSetValue(Value<? extends T> newValue) {
        try {
            Value<? extends T> value = this.threadLocal.get();
            return value;
        }
        finally {
            this.threadLocal.set(newValue);
        }
    }
}

