/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.remoting3.remote;

import java.nio.ByteBuffer;
import java.util.Random;
import org.shaded.jboss.remoting3.remote.Protocol;
import org.xnio.Buffers;

final class ProtocolUtils {
    static final ThreadLocal<Random> randomHolder = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(System.nanoTime() * 1024L + Thread.currentThread().getId());
        }
    };

    private ProtocolUtils() {
    }

    static void writeString(ByteBuffer buffer, byte type, String data) {
        buffer.put(type);
        byte[] bytes = data.getBytes(Protocol.UTF_8);
        int length = Math.min(255, bytes.length);
        buffer.put((byte)length);
        buffer.put(bytes, 0, length);
    }

    static void writeString(ByteBuffer buffer, String data) {
        byte[] bytes = data.getBytes(Protocol.UTF_8);
        int length = Math.min(255, bytes.length);
        buffer.put((byte)length);
        buffer.put(bytes, 0, length);
    }

    static void writeByte(ByteBuffer buffer, int type, int value) {
        buffer.put((byte)type);
        buffer.put((byte)1);
        buffer.put((byte)value);
    }

    static void writeShort(ByteBuffer buffer, int type, int value) {
        buffer.put((byte)type);
        buffer.put((byte)2);
        buffer.putShort((short)value);
    }

    static void writeInt(ByteBuffer buffer, int type, int value) {
        buffer.put((byte)type);
        buffer.put((byte)4);
        buffer.putInt(value);
    }

    static void writeLong(ByteBuffer buffer, int type, long value) {
        buffer.put((byte)type);
        buffer.put((byte)8);
        buffer.putLong(value);
    }

    static void writeBytes(ByteBuffer buffer, int type, byte[] value) {
        buffer.put((byte)type);
        buffer.put((byte)value.length);
        buffer.put(value);
    }

    static void writeEmpty(ByteBuffer buffer, int type) {
        buffer.put((byte)type);
        buffer.put((byte)0);
    }

    static String readString(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        return new String(Buffers.take(buffer, length), Protocol.UTF_8);
    }

    static int readInt(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        return ProtocolUtils.readIntData(buffer, length);
    }

    static int readIntData(ByteBuffer buffer, int length) {
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                return buffer.get() & 0xFF;
            }
            case 2: {
                return buffer.getShort() & 0xFFFF;
            }
            case 3: {
                return ((buffer.get() & 0xFF) << 16) + (buffer.getShort() & 0xFFFF);
            }
            case 4: {
                return buffer.getInt();
            }
        }
        Buffers.skip(buffer, length - 4);
        return buffer.getInt();
    }

    static int readUnsignedShort(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                return buffer.get() & 0xFF;
            }
            case 2: {
                return buffer.getShort() & 0xFFFF;
            }
        }
        Buffers.skip(buffer, length - 2);
        return buffer.getShort() & 0xFFFF;
    }

    static long readLong(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        switch (length) {
            case 0: {
                return 0L;
            }
            case 1: {
                return (long)buffer.get() & 0xFFL;
            }
            case 2: {
                return (long)buffer.getShort() & 0xFFFFL;
            }
            case 3: {
                return (((long)buffer.get() & 0xFFL) << 16) + ((long)buffer.getShort() & 0xFFFFL);
            }
            case 4: {
                return (long)buffer.getInt() & 0xFFFFFFFFL;
            }
            case 5: {
                return (((long)buffer.get() & 0xFFL) << 32) + ((long)buffer.getInt() & 0xFFFFFFFFL);
            }
            case 6: {
                return (((long)buffer.getShort() & 0xFFFFL) << 32) + ((long)buffer.getInt() & 0xFFFFFFFFL);
            }
            case 7: {
                return (((long)buffer.get() & 0xFFL) << 48) + (((long)buffer.getShort() & 0xFFFFL) << 32) + ((long)buffer.getInt() & 0xFFFFFFFFL);
            }
            case 8: {
                return buffer.getLong();
            }
        }
        Buffers.skip(buffer, length - 8);
        return buffer.getLong();
    }
}

