/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.shaded.jboss.remoting3.RemotingOptions;
import org.shaded.jboss.remoting3.Version;
import org.shaded.jboss.remoting3.remote.ExternalSaslServerFactory;
import org.shaded.jboss.remoting3.remote.ProtocolUtils;
import org.shaded.jboss.remoting3.remote.RemoteAuthLogger;
import org.shaded.jboss.remoting3.remote.RemoteConnection;
import org.shaded.jboss.remoting3.remote.RemoteConnectionHandler;
import org.shaded.jboss.remoting3.remote.RemoteLogger;
import org.shaded.jboss.remoting3.remote.RemoteReadListener;
import org.shaded.jboss.remoting3.security.AuthorizingCallbackHandler;
import org.shaded.jboss.remoting3.security.InetAddressPrincipal;
import org.shaded.jboss.remoting3.security.ServerAuthenticationProvider;
import org.shaded.jboss.remoting3.security.UserInfo;
import org.shaded.jboss.remoting3.security.UserPrincipal;
import org.shaded.jboss.remoting3.spi.ConnectionHandler;
import org.shaded.jboss.remoting3.spi.ConnectionHandlerContext;
import org.shaded.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.shaded.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ServerConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final ServerAuthenticationProvider serverAuthenticationProvider;
    private final OptionMap optionMap;
    private final AccessControlContext accessControlContext;
    private final AtomicInteger retryCount = new AtomicInteger(8);
    private final String serverName;

    ServerConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, ServerAuthenticationProvider serverAuthenticationProvider, OptionMap optionMap, AccessControlContext accessControlContext) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        this.optionMap = optionMap;
        this.accessControlContext = accessControlContext;
        this.serverName = optionMap.contains(RemotingOptions.SERVER_NAME) ? optionMap.get(RemotingOptions.SERVER_NAME) : connection.getChannel().getLocalAddress(InetSocketAddress.class).getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(ConnectedMessageChannel channel) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = pooled.getResource();
            sendBuffer.put((byte)0);
            ProtocolUtils.writeString(sendBuffer, (byte)0, this.serverName);
            sendBuffer.flip();
            this.connection.setReadListener(new Initial(), true);
            this.connection.send(pooled);
            ok = true;
            return;
        }
        catch (BufferUnderflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        catch (BufferOverflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    private void saslDispose(SaslServer saslServer) {
        if (saslServer != null) {
            try {
                saslServer.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.server.trace("Failure disposing of SaslServer", e);
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslServer saslServer;
        private final AuthorizingCallbackHandler authorizingCallbackHandler;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslServer saslServer, AuthorizingCallbackHandler authorizingCallbackHandler, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslServer = saslServer;
            this.authorizingCallbackHandler = authorizingCallbackHandler;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledBuffer = ServerConnectionOpenListener.this.connection.allocate();
            boolean free = true;
            try {
                int res;
                ByteBuffer buffer = pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ServerConnectionOpenListener.this.connection.handleException(e);
                    ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                    if (free) {
                        pooledBuffer.free();
                    }
                    return;
                }
                if (res == -1) {
                    RemoteLogger.log.trace("Received connection end-of-stream");
                    ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                    ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.server.tracef("Received %s", (Object)buffer);
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        return;
                    }
                    case 4: {
                        RemoteLogger.server.tracef("Server received authentication response", new Object[0]);
                        ServerConnectionOpenListener.this.connection.getChannel().suspendReads();
                        ServerConnectionOpenListener.this.connection.getExecutor().execute(new AuthStepRunnable(false, this.saslServer, this.authorizingCallbackHandler, pooledBuffer, this.remoteEndpointName, this.behavior, this.maxInboundChannels, this.maxOutboundChannels));
                        free = false;
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request (cancelling authentication)");
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        Initial initial = new Initial();
                        ServerConnectionOpenListener.this.connection.setReadListener(initial, true);
                        initial.handleClientCapabilities(buffer);
                        initial.sendCapabilities();
                        return;
                    }
                }
                RemoteLogger.server.unknownProtocolId(msgType);
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
            }
            catch (BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            catch (BufferOverflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            finally {
                if (free) {
                    pooledBuffer.free();
                }
            }
        }
    }

    final class AuthStepRunnable
    implements Runnable {
        private final boolean isInitial;
        private final SaslServer saslServer;
        private final AuthorizingCallbackHandler authorizingCallbackHandler;
        private final Pooled<ByteBuffer> buffer;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        AuthStepRunnable(boolean isInitial, SaslServer saslServer, AuthorizingCallbackHandler authorizingCallbackHandler, Pooled<ByteBuffer> buffer, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.isInitial = isInitial;
            this.saslServer = saslServer;
            this.authorizingCallbackHandler = authorizingCallbackHandler;
            this.buffer = buffer;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ok = false;
            boolean close = false;
            try {
                Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                try {
                    ByteBuffer sendBuffer = pooled.getResource();
                    int p = sendBuffer.position();
                    try {
                        sendBuffer.put((byte)5);
                        if (SaslUtils.evaluateResponse(this.saslServer, sendBuffer, this.buffer.getResource())) {
                            RemoteLogger.server.tracef("Server sending authentication complete", new Object[0]);
                            final Collection<Principal> principals = this.createPrincipals();
                            final UserInfo userInfo = this.authorizingCallbackHandler.createUserInfo(principals);
                            ServerConnectionOpenListener.this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                                @Override
                                public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                    Object qop = AuthStepRunnable.this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                                    if (!AuthStepRunnable.this.isInitial && ("auth-int".equals(qop) || "auth-conf".equals(qop))) {
                                        ServerConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create(AuthStepRunnable.this.saslServer));
                                    }
                                    RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerConnectionOpenListener.this.connection, principals, userInfo, AuthStepRunnable.this.maxInboundChannels, AuthStepRunnable.this.maxOutboundChannels, AuthStepRunnable.this.remoteEndpointName, AuthStepRunnable.this.behavior);
                                    ServerConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                    ServerConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ServerConnectionOpenListener.this.connection), false);
                                    return connectionHandler;
                                }
                            });
                        } else {
                            RemoteLogger.server.tracef("Server sending authentication challenge", new Object[0]);
                            sendBuffer.put(p, (byte)3);
                            if (this.isInitial) {
                                ServerConnectionOpenListener.this.connection.setReadListener(new Authentication(this.saslServer, this.authorizingCallbackHandler, this.remoteEndpointName, this.behavior, this.maxInboundChannels, this.maxOutboundChannels), false);
                            }
                        }
                    }
                    catch (Throwable e) {
                        RemoteLogger.server.tracef(e, "Server sending authentication rejected", new Object[0]);
                        sendBuffer.put(p, (byte)6);
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        if (this.isInitial) {
                            if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() <= 0) {
                                close = true;
                            }
                        }
                        ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), false);
                    }
                    sendBuffer.flip();
                    ServerConnectionOpenListener.this.connection.send(pooled, close);
                    ok = true;
                    ServerConnectionOpenListener.this.connection.getChannel().resumeReads();
                    if (!ok) {
                        pooled.free();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        pooled.free();
                    }
                    throw throwable;
                }
            }
            finally {
                this.buffer.free();
            }
        }

        private Collection<Principal> createPrincipals() {
            ConnectedMessageChannel channel;
            InetSocketAddress address;
            String authorizationId;
            SSLSession session;
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            if (sslChannel != null && (session = sslChannel.getSslSession()) != null) {
                try {
                    principals.add(session.getPeerPrincipal());
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            if ((authorizationId = this.saslServer.getAuthorizationID()) != null) {
                principals.add(new UserPrincipal(authorizationId));
            }
            if ((address = (channel = ServerConnectionOpenListener.this.connection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
                principals.add(new InetAddressPrincipal(address.getAddress()));
            }
            return Collections.unmodifiableCollection(principals);
        }
    }

    final class Initial
    implements ChannelListener<ConnectedMessageChannel> {
        private boolean starttls;
        private Map<String, ?> propertyMap;
        private Map<String, SaslServerFactory> allowedMechanisms;
        private int version = 1;
        private int channelsIn = 40;
        private int channelsOut = 40;
        private String remoteEndpointName;
        private int behavior = 2;

        Initial() {
        }

        void initialiseCapabilities() {
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            boolean channelSecure = Channels.getOption((Configurable)ServerConnectionOpenListener.this.connection.getChannel(), Options.SECURE, false);
            this.starttls = sslChannel != null && !channelSecure;
            LinkedHashMap<String, SaslServerFactory> foundMechanisms = new LinkedHashMap<String, SaslServerFactory>();
            Map<String, Object> propertyMap = SaslUtils.createPropertyMap(ServerConnectionOpenListener.this.optionMap, channelSecure);
            Sequence<String> saslMechs = ServerConnectionOpenListener.this.optionMap.get(Options.SASL_MECHANISMS);
            LinkedHashSet<String> restrictions = saslMechs == null ? null : new LinkedHashSet<String>(saslMechs);
            Sequence<String> saslNoMechs = ServerConnectionOpenListener.this.optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
            HashSet<String> disallowed = saslNoMechs == null ? Collections.emptySet() : new HashSet<String>(saslNoMechs);
            Iterator<SaslServerFactory> factories = SaslUtils.getSaslServerFactories(this.getClass().getClassLoader(), true);
            try {
                if ((restrictions == null || restrictions.contains("EXTERNAL")) && !disallowed.contains("EXTERNAL")) {
                    SSLSession sslSession;
                    if (sslChannel != null && (sslSession = sslChannel.getSslSession()) != null) {
                        Principal principal = sslSession.getPeerPrincipal();
                        if (principal != null) {
                            foundMechanisms.put("EXTERNAL", new ExternalSaslServerFactory(principal));
                        } else {
                            RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of peer principal");
                        }
                    } else {
                        RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of SSL");
                    }
                } else {
                    RemoteLogger.server.trace("No EXTERNAL mechanism due to explicit exclusion");
                }
            }
            catch (IOException sslSession) {
                // empty catch block
            }
            while (factories.hasNext()) {
                SaslServerFactory factory = factories.next();
                RemoteLogger.server.tracef("Trying SASL server factory %s", (Object)factory);
                for (String mechName : factory.getMechanismNames(propertyMap)) {
                    if (restrictions != null && !restrictions.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is not in the allowed list", (Object)mechName);
                        continue;
                    }
                    if (disallowed.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is in the disallowed list", (Object)mechName);
                        continue;
                    }
                    if (foundMechanisms.containsKey(mechName)) {
                        RemoteLogger.server.tracef("Excluding repeated occurrence of mechanism %s", (Object)mechName);
                        continue;
                    }
                    RemoteLogger.server.tracef("Added mechanism %s", (Object)mechName);
                    foundMechanisms.put(mechName, factory);
                }
            }
            this.propertyMap = propertyMap;
            if (restrictions == null) {
                this.allowedMechanisms = foundMechanisms;
            } else {
                LinkedHashMap<String, SaslServerFactory> allowedMechanisms = new LinkedHashMap<String, SaslServerFactory>();
                for (String name : restrictions) {
                    if (!foundMechanisms.containsKey(name)) continue;
                    allowedMechanisms.put(name, (SaslServerFactory)foundMechanisms.get(name));
                }
                this.allowedMechanisms = allowedMechanisms;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(ConnectedMessageChannel channel) {
            ByteBuffer receiveBuffer;
            Pooled<ByteBuffer> pooledBuffer = ServerConnectionOpenListener.this.connection.allocate();
            boolean free = true;
            try {
                int res;
                receiveBuffer = pooledBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ServerConnectionOpenListener.this.connection.handleException(e);
                    if (!free) return;
                    pooledBuffer.free();
                    return;
                }
                if (res == 0) {
                    return;
                }
                if (res == -1) {
                    RemoteLogger.log.trace("Received connection end-of-stream");
                    ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                    return;
                }
                receiveBuffer.flip();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case -16: {
                        RemoteLogger.server.trace("Server received connection alive");
                        ServerConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.server.trace("Server received connection alive ack");
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request");
                        this.handleClientCapabilities(receiveBuffer);
                        this.sendCapabilities();
                        return;
                    }
                    case 7: {
                        RemoteLogger.server.tracef("Server received STARTTLS request", new Object[0]);
                        Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                        boolean ok = false;
                        try {
                            ByteBuffer sendBuffer = pooled.getResource();
                            sendBuffer.put(this.starttls ? (byte)7 : 8);
                            sendBuffer.flip();
                            ServerConnectionOpenListener.this.connection.send(pooled);
                            ok = true;
                            if (this.starttls) {
                                ServerConnectionOpenListener.this.connection.send(RemoteConnection.STARTTLS_SENTINEL);
                            }
                            ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), true);
                            return;
                        }
                        finally {
                            if (!ok) {
                                pooled.free();
                            }
                        }
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        RemoteLogger.server.unknownProtocolId(msgType);
                        ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                        return;
                    }
                }
            }
            catch (BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            RemoteLogger.server.tracef("Server received authentication request", new Object[0]);
            if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() < 1) {
                ServerConnectionOpenListener.this.connection.handleException(new SaslException("Too many authentication failures; connection terminated"), false);
                return;
            }
            final String mechName = this.version < 1 ? Buffers.getModifiedUtf8(receiveBuffer) : ProtocolUtils.readString(receiveBuffer);
            final SaslServerFactory saslServerFactory = this.allowedMechanisms.get(mechName);
            final AuthorizingCallbackHandler callbackHandler = ServerConnectionOpenListener.this.serverAuthenticationProvider.getCallbackHandler(mechName);
            if (saslServerFactory == null || callbackHandler == null) {
                this.rejectAuthentication(mechName);
                return;
            }
            final String protocol = ServerConnectionOpenListener.this.optionMap.contains(RemotingOptions.SASL_PROTOCOL) ? ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.SASL_PROTOCOL) : "remoting";
            SaslServer saslServer = AccessController.doPrivileged(new PrivilegedAction<SaslServer>(){

                @Override
                public SaslServer run() {
                    try {
                        return saslServerFactory.createSaslServer(mechName, protocol, ServerConnectionOpenListener.this.serverName, Initial.this.propertyMap, callbackHandler);
                    }
                    catch (SaslException e) {
                        RemoteLogger.server.trace("Unable to create SaslServer", e);
                        return null;
                    }
                }
            }, ServerConnectionOpenListener.this.accessControlContext);
            if (saslServer == null) {
                this.rejectAuthentication(mechName);
                return;
            }
            ServerConnectionOpenListener.this.connection.getChannel().suspendReads();
            ServerConnectionOpenListener.this.connection.getExecutor().execute(new AuthStepRunnable(true, saslServer, callbackHandler, pooledBuffer, this.remoteEndpointName, this.behavior, this.channelsIn, this.channelsOut));
            return;
            finally {
                if (free) {
                    pooledBuffer.free();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rejectAuthentication(String mechName) {
            RemoteAuthLogger.authLog.rejectedInvalidMechanism(mechName);
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = pooled.getResource();
                sendBuffer.put((byte)6);
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }

        void handleClientCapabilities(ByteBuffer receiveBuffer) {
            boolean useDefaultChannels = true;
            int channelsIn = 40;
            int channelsOut = 40;
            block8: while (receiveBuffer.hasRemaining()) {
                byte type = receiveBuffer.get();
                int len = receiveBuffer.get() & 0xFF;
                ByteBuffer data = Buffers.slice(receiveBuffer, len);
                switch (type) {
                    case 0: {
                        byte version = data.get();
                        RemoteLogger.server.tracef("Server received capability: version %d", (Object)(version & 0xFF));
                        this.version = Math.min(1, version & 0xFF);
                        continue block8;
                    }
                    case 3: {
                        this.remoteEndpointName = Buffers.getModifiedUtf8(data);
                        RemoteLogger.server.tracef("Server received capability: remote endpoint name \"%s\"", (Object)this.remoteEndpointName);
                        continue block8;
                    }
                    case 4: {
                        this.behavior |= 1;
                        this.behavior &= 0xFFFFFFFD;
                        RemoteLogger.server.tracef("Server received capability: message close protocol supported", new Object[0]);
                        continue block8;
                    }
                    case 5: {
                        this.behavior &= 0xFFFFFFFD;
                        String remoteVersionString = Buffers.getModifiedUtf8(data);
                        RemoteLogger.server.tracef("Server received capability: remote version is \"%s\"", (Object)remoteVersionString);
                        continue block8;
                    }
                    case 6: {
                        useDefaultChannels = false;
                        channelsOut = ProtocolUtils.readIntData(data, len);
                        RemoteLogger.server.tracef("Server received capability: remote channels in is \"%d\"", (Object)channelsOut);
                        continue block8;
                    }
                    case 7: {
                        useDefaultChannels = false;
                        channelsIn = ProtocolUtils.readIntData(data, len);
                        RemoteLogger.server.tracef("Server received capability: remote channels out is \"%d\"", (Object)channelsIn);
                        continue block8;
                    }
                }
                RemoteLogger.server.tracef("Server received unknown capability %02x", (Object)(type & 0xFF));
            }
            if (!useDefaultChannels) {
                this.channelsIn = channelsIn;
                this.channelsOut = channelsOut;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendCapabilities() {
            if (this.allowedMechanisms == null) {
                this.initialiseCapabilities();
            }
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = pooled.getResource();
                sendBuffer.put((byte)1);
                ProtocolUtils.writeByte(sendBuffer, 0, this.version);
                String localEndpointName = ServerConnectionOpenListener.this.connectionProviderContext.getEndpoint().getName();
                if (localEndpointName != null) {
                    ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
                }
                if (this.starttls) {
                    ProtocolUtils.writeEmpty(sendBuffer, 2);
                }
                for (String mechName : this.allowedMechanisms.keySet()) {
                    ProtocolUtils.writeString(sendBuffer, (byte)1, mechName);
                }
                ProtocolUtils.writeEmpty(sendBuffer, 4);
                ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
                ProtocolUtils.writeInt(sendBuffer, 6, ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
                ProtocolUtils.writeInt(sendBuffer, 7, ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
                return;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }
    }
}

