/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.threads;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import org.shaded.jboss.threads.Dependency;

public final class DependencyTaskBuilder {
    private final Collection<Dependency> dependencies = new LinkedHashSet<Dependency>();
    private final Executor executor;
    private final Runnable task;

    DependencyTaskBuilder(Executor executor, Runnable task) {
        this.executor = executor;
        this.task = task;
    }

    public DependencyTaskBuilder add(Dependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency is null");
        }
        this.dependencies.add(dependency);
        return this;
    }

    public DependencyTaskBuilder add(Collection<Dependency> dependencies) {
        this.dependencies.addAll(dependencies);
        return this;
    }

    public DependencyTaskBuilder add(Dependency ... dependencies) {
        this.dependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public Dependency create() {
        Collection<Dependency> dependencies = this.dependencies;
        Dependency dependentTask = new Dependency(this.executor, this.task, dependencies.size() + 1);
        for (Dependency dependency : dependencies) {
            dependency.addDependent(dependentTask);
        }
        dependentTask.dependencyFinished();
        return dependentTask;
    }
}

