/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.threads;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class SimpleLock
implements Lock {
    private boolean locked;

    SimpleLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        boolean intr = Thread.interrupted();
        try {
            SimpleLock simpleLock = this;
            synchronized (simpleLock) {
                while (this.locked) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
                this.locked = true;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockInterruptibly() throws InterruptedException {
        SimpleLock simpleLock = this;
        synchronized (simpleLock) {
            while (this.locked) {
                this.wait();
            }
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock() {
        SimpleLock simpleLock = this;
        synchronized (simpleLock) {
            if (this.locked) {
                return false;
            }
            this.locked = true;
            return true;
        }
    }

    private static long clipHigh(long value) {
        return value < 0L ? Long.MAX_VALUE : value;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (time < 0L) {
            return this.tryLock();
        }
        long now = System.currentTimeMillis();
        long deadline = SimpleLock.clipHigh(now + unit.toMillis(time));
        SimpleLock simpleLock = this;
        synchronized (simpleLock) {
            if (!this.locked) {
                this.locked = true;
                return true;
            }
            while (true) {
                long remaining;
                if ((remaining = deadline - now) <= 0L) {
                    return false;
                }
                this.wait(remaining);
                if (!this.locked) {
                    this.locked = true;
                    return true;
                }
                now = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        SimpleLock simpleLock = this;
        synchronized (simpleLock) {
            this.locked = false;
        }
    }

    @Override
    public Condition newCondition() {
        return new SimpleCondition();
    }

    public final class SimpleCondition
    implements Condition {
        SimpleCondition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await() throws InterruptedException {
            SimpleCondition simpleCondition = this;
            synchronized (simpleCondition) {
                SimpleLock.this.unlock();
                try {
                    this.wait();
                }
                finally {
                    SimpleLock.this.lock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitUninterruptibly() {
            boolean intr = Thread.interrupted();
            try {
                SimpleCondition simpleCondition = this;
                synchronized (simpleCondition) {
                    SimpleLock.this.unlock();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                    finally {
                        SimpleLock.this.lock();
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            SimpleLock.this.unlock();
            try {
                long start = System.nanoTime();
                SimpleCondition simpleCondition = this;
                synchronized (simpleCondition) {
                    this.wait(nanosTimeout / 1000000L, (int)(nanosTimeout % 1000000L));
                }
                long l = nanosTimeout - (System.nanoTime() - start);
                return l;
            }
            finally {
                SimpleLock.this.lock();
            }
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException("not implemented yet");
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            throw new UnsupportedOperationException("not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signal() {
            SimpleCondition simpleCondition = this;
            synchronized (simpleCondition) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signalAll() {
            SimpleCondition simpleCondition = this;
            synchronized (simpleCondition) {
                this.notifyAll();
            }
        }
    }
}

