/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.threads;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class ThreadLocalResetter
implements Runnable {
    private static final ThreadLocalResetter INSTANCE = new ThreadLocalResetter();
    private static final Field THREAD_LOCAL_MAP_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = Thread.class.getDeclaredField("threadLocals");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            return field;
        }
    });
    private static final Field INHERITABLE_THREAD_LOCAL_MAP_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = Thread.class.getDeclaredField("inheritableThreadLocals");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            return field;
        }
    });

    static ThreadLocalResetter getInstance() {
        return INSTANCE;
    }

    private ThreadLocalResetter() {
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        ThreadLocalResetter.clear(thread, THREAD_LOCAL_MAP_FIELD);
        ThreadLocalResetter.clear(thread, INHERITABLE_THREAD_LOCAL_MAP_FIELD);
    }

    private static void clear(Thread currentThread, Field field) {
        try {
            if (field != null) {
                field.set(currentThread, null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Thread-local resetting Runnable";
    }
}

