/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jgrapht.alg;

import java.util.HashSet;
import java.util.Set;
import org.shaded.jgrapht.UndirectedGraph;
import org.shaded.jgrapht.alg.BlockCutpointGraph;

public class BiconnectivityInspector<V, E> {
    private BlockCutpointGraph<V, E> blockCutpointGraph;

    public BiconnectivityInspector(UndirectedGraph<V, E> graph) {
        this.blockCutpointGraph = new BlockCutpointGraph<V, E>(graph);
    }

    public Set<Set<V>> getBiconnectedVertexComponents() {
        HashSet<Set<V>> biconnectedVertexComponents = new HashSet<Set<V>>();
        for (UndirectedGraph subgraph : this.blockCutpointGraph.vertexSet()) {
            if (subgraph.edgeSet().isEmpty()) continue;
            biconnectedVertexComponents.add(subgraph.vertexSet());
        }
        return biconnectedVertexComponents;
    }

    public Set<Set<V>> getBiconnectedVertexComponents(V vertex) {
        HashSet<Set<V>> vertexComponents = new HashSet<Set<V>>();
        for (Set<V> vertexComponent : this.getBiconnectedVertexComponents()) {
            if (!vertexComponent.contains(vertex)) continue;
            vertexComponents.add(vertexComponent);
        }
        return vertexComponents;
    }

    public Set<V> getCutpoints() {
        return this.blockCutpointGraph.getCutpoints();
    }

    public boolean isBiconnected() {
        return this.blockCutpointGraph.vertexSet().size() == 1;
    }
}

