/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jgrapht.alg.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UnionFind<T> {
    private Map<T, T> parentMap = new HashMap<T, T>();
    private Map<T, Integer> rankMap = new HashMap<T, Integer>();

    public UnionFind(Set<T> elements) {
        for (T element : elements) {
            this.parentMap.put(element, element);
            this.rankMap.put(element, 0);
        }
    }

    public void addElement(T element) {
        this.parentMap.put(element, element);
        this.rankMap.put(element, 0);
    }

    protected Map<T, T> getParentMap() {
        return this.parentMap;
    }

    protected Map<T, Integer> getRankMap() {
        return this.rankMap;
    }

    public T find(T element) {
        if (!this.parentMap.containsKey(element)) {
            throw new IllegalArgumentException("elements must be contained in given set");
        }
        T parent = this.parentMap.get(element);
        if (parent.equals(element)) {
            return element;
        }
        T newParent = this.find(parent);
        this.parentMap.put(element, newParent);
        return newParent;
    }

    public void union(T element1, T element2) {
        int rank2;
        T parent2;
        if (!this.parentMap.containsKey(element1) || !this.parentMap.containsKey(element2)) {
            throw new IllegalArgumentException("elements must be contained in given set");
        }
        T parent1 = this.find(element1);
        if (parent1.equals(parent2 = this.find(element2))) {
            return;
        }
        int rank1 = this.rankMap.get(parent1);
        if (rank1 > (rank2 = this.rankMap.get(parent2).intValue())) {
            this.parentMap.put(parent2, parent1);
        } else if (rank1 < rank2) {
            this.parentMap.put(parent1, parent2);
        } else {
            this.parentMap.put(parent2, parent1);
            this.rankMap.put(parent1, rank1 + 1);
        }
    }
}

