/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.shaded.jgrapht.Graph;
import org.shaded.jgrapht.VertexFactory;
import org.shaded.jgrapht.generate.GraphGenerator;
import org.shaded.jgrapht.graph.DefaultDirectedGraph;
import org.shaded.jgrapht.graph.SimpleDirectedGraph;
import org.shaded.jgrapht.graph.SimpleGraph;

public class RandomGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private static long seedUniquifier = 8682522807148012L;
    protected int numOfVertexes;
    protected int numOfEdges;
    protected Random randomizer;
    private long randomizerSeed;

    public RandomGraphGenerator(int aNumOfVertexes, int aNumOfEdges) {
        if (aNumOfVertexes < 0 || aNumOfEdges < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.numOfVertexes = aNumOfVertexes;
        this.numOfEdges = aNumOfEdges;
        this.randomizerSeed = RandomGraphGenerator.chooseRandomSeedOnce();
        this.randomizer = new Random(this.randomizerSeed);
    }

    private static synchronized long chooseRandomSeedOnce() {
        return ++seedUniquifier + System.nanoTime();
    }

    private void resetRandomSeed() {
        this.randomizer.setSeed(this.randomizerSeed);
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        this.resetRandomSeed();
        HashMap<Integer, V> orderToVertexMap = new HashMap<Integer, V>(this.numOfVertexes);
        for (int i = 0; i < this.numOfVertexes; ++i) {
            V currVertex = vertexFactory.createVertex();
            target.addVertex(currVertex);
            orderToVertexMap.put(i, currVertex);
        }
        if (target.vertexSet().size() != this.numOfVertexes) {
            throw new IllegalArgumentException("Vertex factory did not produce " + this.numOfVertexes + " distinct vertices.");
        }
        EdgeTopologyFactory<V, E> edgesFactory = this.edgeTopologyFactoryChooser(target, this.numOfEdges);
        if (!edgesFactory.isNumberOfEdgesValid(target, this.numOfEdges)) {
            throw new IllegalArgumentException("numOfEdges is not valid for the graph type \n-> Invalid number Of Edges=" + this.numOfEdges + " for:" + " graph type=" + target.getClass() + " ,number Of Vertexes=" + this.numOfVertexes + "\n-> Advice: For the Max value , check the javadoc for" + " org.jgrapht.generate.RandomGraphGenerator.DefaultEdgeTopologyFactory");
        }
        edgesFactory.createEdges(target, orderToVertexMap, this.numOfEdges, this.randomizer);
    }

    private EdgeTopologyFactory<V, E> edgeTopologyFactoryChooser(Graph<V, E> target, int numOfEdges) {
        return new DefaultEdgeTopologyFactory();
    }

    public class DefaultEdgeTopologyFactory<VV, EE>
    implements EdgeTopologyFactory<VV, EE> {
        @Override
        public void createEdges(Graph<VV, EE> targetGraph, Map<Integer, VV> orderToVertexMap, int numberOfEdges, Random randomizer) {
            int iterationsCounter = 0;
            int edgesCounter = 0;
            while (edgesCounter < numberOfEdges) {
                VV startVertex = orderToVertexMap.get(randomizer.nextInt(RandomGraphGenerator.this.numOfVertexes));
                VV endVertex = orderToVertexMap.get(randomizer.nextInt(RandomGraphGenerator.this.numOfVertexes));
                try {
                    EE resultEdge = targetGraph.addEdge(startVertex, endVertex);
                    if (resultEdge != null) {
                        ++edgesCounter;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++iterationsCounter;
            }
        }

        @Override
        public boolean isNumberOfEdgesValid(Graph<VV, EE> targetGraph, int numberOfEdges) {
            boolean infinite = false;
            int maxAllowedEdges = this.getMaxEdgesForVertexNum(targetGraph);
            if (maxAllowedEdges == -1) {
                infinite = true;
            }
            boolean result = true == infinite ? true : numberOfEdges <= maxAllowedEdges;
            return result;
        }

        public int getMaxEdgesForVertexNum(Graph<VV, EE> targetGraph) {
            int maxAllowedEdges = 0;
            maxAllowedEdges = targetGraph instanceof SimpleGraph ? RandomGraphGenerator.this.numOfVertexes * (RandomGraphGenerator.this.numOfVertexes - 1) / 2 : (targetGraph instanceof SimpleDirectedGraph ? RandomGraphGenerator.this.numOfVertexes * (RandomGraphGenerator.this.numOfVertexes - 1) : (targetGraph instanceof DefaultDirectedGraph ? RandomGraphGenerator.this.numOfVertexes * RandomGraphGenerator.this.numOfVertexes : -1));
            return maxAllowedEdges;
        }
    }

    public static interface EdgeTopologyFactory<VV, EE> {
        public void createEdges(Graph<VV, EE> var1, Map<Integer, VV> var2, int var3, Random var4);

        public boolean isNumberOfEdgesValid(Graph<VV, EE> var1, int var2);
    }
}

