/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jolokia.client;

import java.io.IOException;
import org.shaded.apache.http.HttpException;
import org.shaded.apache.http.HttpHost;
import org.shaded.apache.http.HttpRequest;
import org.shaded.apache.http.HttpRequestInterceptor;
import org.shaded.apache.http.auth.AuthScheme;
import org.shaded.apache.http.auth.AuthScope;
import org.shaded.apache.http.auth.AuthState;
import org.shaded.apache.http.auth.Credentials;
import org.shaded.apache.http.auth.UsernamePasswordCredentials;
import org.shaded.apache.http.client.CredentialsProvider;
import org.shaded.apache.http.impl.auth.BasicScheme;
import org.shaded.apache.http.impl.client.BasicCredentialsProvider;
import org.shaded.apache.http.impl.client.HttpClientBuilder;
import org.shaded.apache.http.protocol.HttpContext;
import org.shaded.jolokia.client.J4pAuthenticator;

public class BasicAuthenticator
implements J4pAuthenticator {
    private boolean preemptive = false;

    public BasicAuthenticator() {
        this(false);
    }

    public BasicAuthenticator(boolean pPreemptive) {
        this.preemptive = pPreemptive;
    }

    public J4pAuthenticator preemptive() {
        this.preemptive = true;
        return this;
    }

    public void authenticate(HttpClientBuilder pBuilder, String pUser, String pPassword) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY), new UsernamePasswordCredentials(pUser, pPassword));
        pBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.preemptive) {
            pBuilder.addInterceptorFirst(new PreemptiveAuthInterceptor(new BasicScheme()));
        }
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private AuthScheme authScheme;

        PreemptiveAuthInterceptor(AuthScheme pScheme) {
            this.authScheme = pScheme;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials given for preemptive authentication");
                }
                authState.update(this.authScheme, creds);
            }
        }
    }
}

