/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.core.launcher;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class VersionComparator
implements Comparator<String> {
    public static VersionComparator INSTANCE = new VersionComparator();

    private VersionComparator() {
    }

    public static int compareVersion(String version1, String version2) {
        return INSTANCE.compare(version1, version2);
    }

    @Override
    public int compare(String o1, String o2) {
        Integer vi2;
        Integer vi1;
        String[] vs2;
        String[] vs1 = o1.split("\\.");
        int len = vs1.length > (vs2 = o2.split("\\.")).length ? vs1.length : vs2.length;
        List<Integer> v1 = VersionComparator.convert(vs1, len);
        List<Integer> v2 = VersionComparator.convert(vs2, len);
        int result = 0;
        for (int i = 0; i < len && (result = (vi1 = v1.get(i)).compareTo(vi2 = v2.get(i))) == 0; ++i) {
        }
        return result;
    }

    private static List<Integer> convert(String[] version, int len) {
        ArrayList<Integer> result = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            if (i < version.length) {
                String s = version[i];
                if ("x".equalsIgnoreCase(s)) {
                    result.add(0);
                    continue;
                }
                try {
                    result.add(Integer.valueOf(s));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Version part %s is not a valid integer", s), e);
                }
            }
            result.add(0);
        }
        return result;
    }
}

