/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.plugin.core;

import java.io.IOException;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.as.controller.client.helpers.Operations;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.wildfly.plugin.core.ContainerDescription;
import org.shaded.wildfly.plugin.core.OperationExecutionException;

class DefaultContainerDescription
implements ContainerDescription {
    private final String productName;
    private final String productVersion;
    private final String releaseVersion;
    private final String launchType;
    private final boolean isDomain;

    private DefaultContainerDescription(String productName, String productVersion, String releaseVersion, String launchType, boolean isDomain) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.releaseVersion = releaseVersion;
        this.launchType = launchType;
        this.isDomain = isDomain;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public String getLaunchType() {
        return this.launchType;
    }

    @Override
    public boolean isDomain() {
        return this.isDomain;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append(this.productName);
        if (this.productVersion != null) {
            result.append(' ').append(this.productVersion);
            if (this.releaseVersion != null) {
                result.append(" (WildFly Core ").append(this.releaseVersion).append(')');
            }
        } else if (this.releaseVersion != null) {
            result.append(' ').append(this.releaseVersion);
        }
        if (this.launchType != null) {
            result.append(" - launch-type: ").append(this.launchType);
        }
        return result.toString();
    }

    static DefaultContainerDescription lookup(ModelControllerClient client) throws IOException, OperationExecutionException {
        ModelNode op = Operations.createReadResourceOperation(new ModelNode().setEmptyList());
        op.get("include-runtime").set(true);
        ModelNode result = client.execute(op);
        if (Operations.isSuccessfulOutcome(result)) {
            ModelNode model = Operations.readResult(result);
            String productName = DefaultContainerDescription.getValue(model, "product-name", "WildFly");
            String productVersion = DefaultContainerDescription.getValue(model, "product-version");
            String releaseVersion = DefaultContainerDescription.getValue(model, "release-version");
            String launchType = DefaultContainerDescription.getValue(model, "launch-type");
            return new DefaultContainerDescription(productName, productVersion, releaseVersion, launchType, "DOMAIN".equalsIgnoreCase(launchType));
        }
        throw new OperationExecutionException(op, result);
    }

    private static String getValue(ModelNode model, String attributeName) {
        return DefaultContainerDescription.getValue(model, attributeName, null);
    }

    private static String getValue(ModelNode model, String attributeName, String defaultValue) {
        if (model.hasDefined(attributeName)) {
            return model.get(attributeName).asString();
        }
        return defaultValue;
    }
}

