/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.manager;

import java.util.Arrays;
import org.shaded.wildfly.security.manager.WildFlySecurityManager;
import org.shaded.wildfly.security.manager.WildFlySecurityManagerPermission;

public final class StackInspector {
    private static final StackInspector INSTANCE = new StackInspector();

    private StackInspector() {
    }

    public static StackInspector getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof WildFlySecurityManager) {
            securityManager.checkPermission(WildFlySecurityManagerPermission.GET_STACK_INSPECTOR_PERMISSION, INSTANCE.getCallerClass(1));
        } else if (securityManager != null) {
            securityManager.checkPermission(WildFlySecurityManagerPermission.GET_STACK_INSPECTOR_PERMISSION);
        }
        return INSTANCE;
    }

    public Class<?> getCallerClass(int skipFrames) {
        return WildFlySecurityManager.getCallerClass(Math.max(0, skipFrames) + 2);
    }

    public Class<?>[] getCallStack(int skipFrames, int numFrames) {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        int from = Math.max(0, skipFrames) + 2;
        return Arrays.copyOfRange(stack, from, Math.min(from + numFrames, stack.length));
    }

    public Class<?>[] getCallStack(int skipFrames) {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        int from = Math.max(0, skipFrames) + 2;
        return Arrays.copyOfRange(stack, from, stack.length);
    }

    public Class<?>[] getCallStack() {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        return Arrays.copyOfRange(stack, 2, stack.length);
    }

    public boolean callStackContains(Class<?> clazz) {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        for (int i = 2; i < stack.length; ++i) {
            if (stack[i] != clazz) continue;
            return true;
        }
        return false;
    }
}

