/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.manager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.shaded.wildfly.security.manager.WildFlySecurityManagerPermissionCollection;
import org.shaded.wildfly.security.manager._private.SecurityMessages;

public final class WildFlySecurityManagerPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;
    static final WildFlySecurityManagerPermission DO_UNCHECKED_PERMISSION = Name.doUnchecked.getPermission();
    static final WildFlySecurityManagerPermission GET_STACK_INSPECTOR_PERMISSION = Name.getStackInspector.getPermission();
    static final Name[] values = Name.values();
    private transient Name name;

    WildFlySecurityManagerPermission(Name name) {
        super(name.toString());
        this.name = name;
    }

    public WildFlySecurityManagerPermission(String name) {
        this(Name.of(name));
    }

    public WildFlySecurityManagerPermission(String name, String actions) {
        this(name);
        if (actions != null && !actions.isEmpty()) {
            throw SecurityMessages.permission.invalidAction(actions, 0, actions);
        }
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new WildFlySecurityManagerPermissionCollection();
    }

    @Override
    public boolean implies(Permission p) {
        return p instanceof WildFlySecurityManagerPermission && this.name == ((WildFlySecurityManagerPermission)p).name;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof WildFlySecurityManagerPermission && this.name == ((WildFlySecurityManagerPermission)obj).name;
    }

    @Override
    public int hashCode() {
        return (this.name.ordinal() + 5) * 51;
    }

    Name getKind() {
        return this.name;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.name = Name.of(this.getName());
    }

    static enum Name {
        doUnchecked,
        getStackInspector;

        private final WildFlySecurityManagerPermission permission = new WildFlySecurityManagerPermission(this);

        WildFlySecurityManagerPermission getPermission() {
            return this.permission;
        }

        public static Name of(String name) {
            try {
                return Name.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                throw SecurityMessages.permission.invalidName(name);
            }
        }
    }
}

