/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.permission;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import org.shaded.wildfly.security.manager._private.SecurityMessages;
import org.shaded.wildfly.security.permission.ElytronPermissionCollection;

public final class ElytronPermission
extends Permission {
    private static final long serialVersionUID = 6124294238228442419L;
    static final Name[] values = Name.values();
    private transient Name name;

    ElytronPermission(Name name) {
        super(name.toString());
        this.name = name;
    }

    public ElytronPermission(String name) {
        this(Name.of(name));
    }

    public ElytronPermission(String name, String actions) {
        this(name);
        if (actions != null && !actions.isEmpty()) {
            throw SecurityMessages.permission.invalidAction(actions, 0, actions);
        }
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ElytronPermissionCollection();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public boolean implies(Permission p) {
        return p instanceof ElytronPermission && this.name == ((ElytronPermission)p).name;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ElytronPermission && this.name == ((ElytronPermission)obj).name;
    }

    @Override
    public int hashCode() {
        return (this.name.ordinal() + 5) * 51;
    }

    Name getKind() {
        return this.name;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.name = Name.of(this.getName());
    }

    static enum Name {
        createAuthenticator,
        createAuthenticationContextConfigurationClient,
        createSecurityDomain;

        private final ElytronPermission permission = new ElytronPermission(this);

        ElytronPermission getPermission() {
            return this.permission;
        }

        public static Name of(String name) {
            try {
                return Name.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                throw SecurityMessages.permission.invalidName(name);
            }
        }
    }
}

