/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import org.shaded.wildfly.security.ssl.CipherSuitePredicate;
import org.shaded.wildfly.security.ssl.MechanismDatabase;

final class AndCipherSuitePredicate
extends CipherSuitePredicate {
    private final CipherSuitePredicate[] predicates;

    AndCipherSuitePredicate(CipherSuitePredicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    boolean test(MechanismDatabase.Entry entry) {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || predicate.test(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isAlwaysTrue() {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || predicate.isAlwaysTrue()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isAlwaysFalse() {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || !predicate.isAlwaysFalse()) continue;
            return true;
        }
        return false;
    }
}

