/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.shaded.wildfly.security._private.ElytronMessages;
import org.shaded.wildfly.security.ssl.Authentication;
import org.shaded.wildfly.security.ssl.CipherSuitePredicate;
import org.shaded.wildfly.security.ssl.Digest;
import org.shaded.wildfly.security.ssl.Encryption;
import org.shaded.wildfly.security.ssl.KeyAgreement;
import org.shaded.wildfly.security.ssl.MechanismDatabase;
import org.shaded.wildfly.security.ssl.Protocol;
import org.shaded.wildfly.security.ssl.SecurityLevel;
import org.shaded.wildfly.security.util.CodePointIterator;

public abstract class CipherSuiteSelector {
    private final CipherSuiteSelector prev;
    private static final CipherSuiteSelector EMPTY = new CipherSuiteSelector(null){

        @Override
        void applyFilter(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
        }
    };
    static final CipherSuiteSelector OPENSSL_ALL = CipherSuiteSelector.empty().add(CipherSuitePredicate.matchOpenSslAll());
    static final CipherSuiteSelector OPENSSL_DEFAULT = CipherSuiteSelector.openSslAll().deleteFully(CipherSuitePredicate.matchOpenSslDefaultDeletes());

    CipherSuiteSelector(CipherSuiteSelector prev) {
        this.prev = prev;
    }

    public static CipherSuiteSelector empty() {
        return EMPTY;
    }

    public static CipherSuiteSelector openSslDefault() {
        return OPENSSL_DEFAULT;
    }

    public static CipherSuiteSelector openSslAll() {
        return OPENSSL_ALL;
    }

    public CipherSuiteSelector deleteFully(CipherSuitePredicate predicate) {
        return predicate == null ? this : new FullyDeletingCipherSuiteSelector(this, predicate);
    }

    public CipherSuiteSelector deleteFully(String cipherSuiteName) {
        return this.deleteFully(CipherSuitePredicate.matchName(cipherSuiteName));
    }

    public CipherSuiteSelector remove(CipherSuitePredicate predicate) {
        return predicate == null || predicate.isAlwaysFalse() ? this : new RemovingCipherSuiteSelector(this, predicate);
    }

    public CipherSuiteSelector remove(String cipherSuiteName) {
        return this.remove(CipherSuitePredicate.matchName(cipherSuiteName));
    }

    public CipherSuiteSelector add(CipherSuitePredicate predicate) {
        return predicate == null || predicate.isAlwaysFalse() ? this : new AddingCipherSuiteSelector(this, predicate);
    }

    public CipherSuiteSelector add(String cipherSuiteName) {
        return this.add(CipherSuitePredicate.matchName(cipherSuiteName));
    }

    public CipherSuiteSelector pushToEnd(CipherSuitePredicate predicate) {
        return predicate == null || predicate.isAlwaysFalse() || predicate.isAlwaysTrue() ? this : new PushToEndCipherSuiteSelector(this, predicate);
    }

    public CipherSuiteSelector pushToEnd(String cipherSuiteName) {
        return this.pushToEnd(CipherSuitePredicate.matchName(cipherSuiteName));
    }

    public CipherSuiteSelector sortByAlgorithmKeyLength() {
        return new SortByAlgorithmKeyLengthCipherSuiteSelector(this);
    }

    abstract void applyFilter(Set<String> var1, Map<MechanismDatabase.Entry, String> var2);

    private void doEvaluate(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
        if (this.prev != null) {
            this.prev.doEvaluate(enabled, supported);
        }
        this.applyFilter(enabled, supported);
    }

    public final String[] evaluate(String[] supportedMechanisms) {
        MechanismDatabase database = MechanismDatabase.getInstance();
        LinkedHashMap<MechanismDatabase.Entry, String> supportedMap = new LinkedHashMap<MechanismDatabase.Entry, String>(supportedMechanisms.length);
        for (String supportedMechanism : supportedMechanisms) {
            MechanismDatabase.Entry entry = database.getCipherSuite(supportedMechanism);
            if (entry == null) continue;
            supportedMap.put(entry, supportedMechanism);
        }
        LinkedHashSet<String> enabledSet = new LinkedHashSet<String>(supportedMap.size());
        this.doEvaluate(enabledSet, supportedMap);
        return enabledSet.toArray(new String[enabledSet.size()]);
    }

    public static CipherSuiteSelector fromString(String string) throws IllegalArgumentException {
        CodePointIterator i = CodePointIterator.ofString(string);
        CipherSuiteSelector current = CipherSuiteSelector.empty();
        block20: while (i.hasNext()) {
            int cp = i.next();
            switch (cp) {
                case 43: {
                    current = CipherSuiteSelector.parseMoveToEnd(current, i);
                    continue block20;
                }
                case 45: {
                    current = CipherSuiteSelector.parseRemove(current, i);
                    continue block20;
                }
                case 33: {
                    current = CipherSuiteSelector.parseDelete(current, i);
                    continue block20;
                }
                case 64: {
                    current = CipherSuiteSelector.parseSpecial(current, i);
                    continue block20;
                }
                case 61: {
                    throw ElytronMessages.log.mechSelectorTokenNotAllowed("=", i.offset(), string);
                }
                case 44: 
                case 58: {
                    continue block20;
                }
            }
            if (Character.isWhitespace(cp)) continue;
            if (Character.isLetterOrDigit(cp)) {
                i.prev();
                String name = i.delimitedBy(43, 58, 44, 32).drainToString();
                CipherSuitePredicate predicate = CipherSuiteSelector.parsePredicate(i, name);
                if (predicate != null) {
                    current = current.add(predicate);
                    continue;
                }
                switch (name) {
                    case "DEFAULT": {
                        current = current.deleteFully(CipherSuitePredicate.matchOpenSslDefaultDeletes());
                        continue block20;
                    }
                    case "COMPLEMENTOFDEFAULT": {
                        current = current.add(CipherSuitePredicate.matchAnonDH());
                        continue block20;
                    }
                    case "ALL": {
                        current = current.add(CipherSuitePredicate.matchOpenSslAll());
                        continue block20;
                    }
                    case "COMPLEMENTOFALL": {
                        current = current.add(CipherSuitePredicate.matchOpenSslComplementOfAll());
                        continue block20;
                    }
                }
                throw ElytronMessages.log.mechSelectorTokenNotAllowed(name, i.offset(), string);
            }
            throw ElytronMessages.log.mechSelectorUnexpectedChar(cp, i.offset(), string);
        }
        return current;
    }

    private static CipherSuiteSelector parseMoveToEnd(CipherSuiteSelector current, CodePointIterator i) {
        return current.pushToEnd(CipherSuiteSelector.parsePredicate(i));
    }

    private static CipherSuiteSelector parseRemove(CipherSuiteSelector current, CodePointIterator i) {
        return current.remove(CipherSuiteSelector.parsePredicate(i));
    }

    private static CipherSuiteSelector parseDelete(CipherSuiteSelector current, CodePointIterator i) {
        return current.deleteFully(CipherSuiteSelector.parsePredicate(i));
    }

    private static CipherSuiteSelector parseSpecial(CipherSuiteSelector current, CodePointIterator i) {
        String word;
        switch (word = i.delimitedBy(61, 58).drainToString()) {
            case "STRENGTH": {
                if (i.hasNext() && i.next() == 61) {
                    throw ElytronMessages.log.mechSelectorTokenNotAllowed("=", i.offset(), i.drainToString());
                }
                return current.sortByAlgorithmKeyLength();
            }
        }
        throw ElytronMessages.log.mechSelectorUnknownToken(word, i.drainToString());
    }

    private static CipherSuitePredicate parsePredicate(CodePointIterator i) {
        return CipherSuiteSelector.parsePredicate(i, i.delimitedBy(43, 58, 44, 32).drainToString());
    }

    private static CipherSuitePredicate parsePredicate(CodePointIterator i, String word) {
        CipherSuitePredicate item = CipherSuiteSelector.getSimplePredicateByName(word);
        if (i.hasNext() && i.next() == 43) {
            if (item == null) {
                throw ElytronMessages.log.mechSelectorTokenNotAllowed("+", i.offset(), i.drainToString());
            }
            return CipherSuiteSelector.parseAndPredicate(item, i);
        }
        return item;
    }

    private static CipherSuitePredicate parseAndPredicate(CipherSuitePredicate item, CodePointIterator i) {
        ArrayList<CipherSuitePredicate> list = new ArrayList<CipherSuitePredicate>();
        list.add(item);
        do {
            list.add(CipherSuiteSelector.getSimplePredicateByName(i.delimitedBy(43, 58, 44, 32).drainToString()));
        } while (i.hasNext() && i.next() == 43);
        return CipherSuitePredicate.matchAll(list.toArray(new CipherSuitePredicate[list.size()]));
    }

    private static CipherSuitePredicate getSimplePredicateByName(String word) {
        switch (word) {
            case "HIGH": {
                return CipherSuitePredicate.matchLevel(SecurityLevel.HIGH);
            }
            case "MEDIUM": {
                return CipherSuitePredicate.matchLevel(SecurityLevel.MEDIUM);
            }
            case "LOW": {
                return CipherSuitePredicate.matchLevel(SecurityLevel.LOW);
            }
            case "EXP": 
            case "EXPORT": {
                return CipherSuitePredicate.matchLevel(SecurityLevel.EXP40, SecurityLevel.EXP56);
            }
            case "NULL": 
            case "eNULL": {
                return CipherSuitePredicate.matchEncryption(Encryption.NULL);
            }
            case "aNULL": {
                return CipherSuitePredicate.matchAuthentication(Authentication.NULL);
            }
            case "kRSA": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.RSA);
            }
            case "aRSA": {
                return CipherSuitePredicate.matchAuthentication(Authentication.RSA);
            }
            case "RSA": {
                return CipherSuitePredicate.matchAny(CipherSuitePredicate.matchKeyAgreement(KeyAgreement.RSA), CipherSuitePredicate.matchAuthentication(Authentication.RSA));
            }
            case "kDHr": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.DHr);
            }
            case "kDHd": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.DHd);
            }
            case "kDH": {
                return CipherSuitePredicate.matchKeyExchange(KeyAgreement.DHr, KeyAgreement.DHd);
            }
            case "kDHE": 
            case "kEDH": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.DHE);
            }
            case "DHE": 
            case "EDH": {
                return CipherSuitePredicate.matchAll(CipherSuitePredicate.matchKeyAgreement(KeyAgreement.DHE), CipherSuitePredicate.matchNot(CipherSuitePredicate.matchAuthentication(Authentication.NULL)));
            }
            case "ADH": {
                return CipherSuitePredicate.matchAnonDH();
            }
            case "DH": {
                return CipherSuitePredicate.matchAll(CipherSuitePredicate.matchKeyExchange(KeyAgreement.DHE, KeyAgreement.DHd, KeyAgreement.DHr, KeyAgreement.ECDHe, KeyAgreement.ECDHr, KeyAgreement.ECDHE), CipherSuitePredicate.matchAuthentication(Authentication.DH, Authentication.ECDH, Authentication.NULL));
            }
            case "kECDHr": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.ECDHr);
            }
            case "kECDHe": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.ECDHe);
            }
            case "kECDH": {
                return CipherSuitePredicate.matchKeyExchange(KeyAgreement.ECDHe, KeyAgreement.ECDHr);
            }
            case "kEECDH": 
            case "kECDHE": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.ECDHE);
            }
            case "ECDHE": 
            case "EECDHE": {
                return CipherSuitePredicate.matchAll(CipherSuitePredicate.matchKeyAgreement(KeyAgreement.ECDHE), CipherSuitePredicate.matchNot(CipherSuitePredicate.matchAuthentication(Authentication.NULL)));
            }
            case "AECDH": {
                return CipherSuitePredicate.matchAll(CipherSuitePredicate.matchKeyExchange(KeyAgreement.ECDHe, KeyAgreement.ECDHr, KeyAgreement.ECDHE), CipherSuitePredicate.matchAuthentication(Authentication.NULL));
            }
            case "ECDH": {
                return CipherSuitePredicate.matchKeyExchange(KeyAgreement.ECDHe, KeyAgreement.ECDHr, KeyAgreement.ECDHE);
            }
            case "DSS": 
            case "aDSS": {
                return CipherSuitePredicate.matchAuthentication(Authentication.DSS);
            }
            case "aDH": {
                return CipherSuitePredicate.matchAuthentication(Authentication.DH);
            }
            case "aECDH": {
                return CipherSuitePredicate.matchAuthentication(Authentication.ECDH);
            }
            case "ECDSA": 
            case "aECDSA": {
                return CipherSuitePredicate.matchAuthentication(Authentication.ECDSA);
            }
            case "kFZA": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.FZA);
            }
            case "aFZA": {
                return CipherSuitePredicate.matchAuthentication(Authentication.FZA);
            }
            case "eFZA": {
                return CipherSuitePredicate.matchEncryption(Encryption.FZA);
            }
            case "FZA": {
                return CipherSuitePredicate.matchAny(CipherSuitePredicate.matchKeyAgreement(KeyAgreement.FZA), CipherSuitePredicate.matchAuthentication(Authentication.FZA), CipherSuitePredicate.matchEncryption(Encryption.FZA));
            }
            case "TLSv1.2": {
                return CipherSuitePredicate.matchProtocol(Protocol.TLSv1_2);
            }
            case "TLSv1": {
                return CipherSuitePredicate.matchProtocol(Protocol.TLSv1);
            }
            case "SSLv3": {
                return CipherSuitePredicate.matchProtocol(Protocol.SSLv3);
            }
            case "SSLv2": {
                return CipherSuitePredicate.matchProtocol(Protocol.SSLv2);
            }
            case "AES128": {
                return CipherSuitePredicate.matchEncryption(Encryption.AES128, Encryption.AES128GCM);
            }
            case "AES256": {
                return CipherSuitePredicate.matchEncryption(Encryption.AES256, Encryption.AES256GCM);
            }
            case "AES": {
                return CipherSuitePredicate.matchEncryption(Encryption.AES128, Encryption.AES128GCM, Encryption.AES256, Encryption.AES256GCM);
            }
            case "AESGCM": {
                return CipherSuitePredicate.matchEncryption(Encryption.AES128GCM, Encryption.AES256GCM);
            }
            case "CAMELLIA128": {
                return CipherSuitePredicate.matchEncryption(Encryption.CAMELLIA128);
            }
            case "CAMELLIA256": {
                return CipherSuitePredicate.matchEncryption(Encryption.CAMELLIA256);
            }
            case "CAMELLIA": {
                return CipherSuitePredicate.matchEncryption(Encryption.CAMELLIA128, Encryption.CAMELLIA256);
            }
            case "3DES": {
                return CipherSuitePredicate.matchEncryption(Encryption._3DES);
            }
            case "DES": {
                return CipherSuitePredicate.matchEncryption(Encryption.DES);
            }
            case "RC4": {
                return CipherSuitePredicate.matchEncryption(Encryption.RC4);
            }
            case "RC2": {
                return CipherSuitePredicate.matchEncryption(Encryption.RC2);
            }
            case "IDEA": {
                return CipherSuitePredicate.matchEncryption(Encryption.IDEA);
            }
            case "SEED": {
                return CipherSuitePredicate.matchEncryption(Encryption.SEED);
            }
            case "MD5": {
                return CipherSuitePredicate.matchDigest(Digest.MD5);
            }
            case "SHA": 
            case "SHA1": {
                return CipherSuitePredicate.matchDigest(Digest.SHA1);
            }
            case "SHA256": {
                return CipherSuitePredicate.matchDigest(Digest.SHA256);
            }
            case "SHA384": {
                return CipherSuitePredicate.matchDigest(Digest.SHA384);
            }
            case "aGOST": {
                return CipherSuitePredicate.matchAuthentication(Authentication.GOST01, Authentication.GOST94);
            }
            case "aGOST01": {
                return CipherSuitePredicate.matchAuthentication(Authentication.GOST01);
            }
            case "aGOST94": {
                return CipherSuitePredicate.matchAuthentication(Authentication.GOST94);
            }
            case "kGOST": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.GOST);
            }
            case "GOST94": {
                return CipherSuitePredicate.matchDigest(Digest.GOST94);
            }
            case "GOST89MAC": {
                return CipherSuitePredicate.matchDigest(Digest.GOST89MAC);
            }
            case "kPSK": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.PSK);
            }
            case "aPSK": {
                return CipherSuitePredicate.matchAuthentication(Authentication.PSK);
            }
            case "PSK": {
                return CipherSuitePredicate.matchAny(CipherSuitePredicate.matchAuthentication(Authentication.PSK), CipherSuitePredicate.matchKeyAgreement(KeyAgreement.PSK));
            }
            case "kRSAPSK": 
            case "RSAPSK": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.RSAPSK);
            }
            case "DHEPSK": 
            case "EDHPSK": 
            case "kDHEPSK": 
            case "kEDHPSK": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.DHEPSK);
            }
            case "EECDHPSK": 
            case "kEECDHPSK": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.ECDHEPSK);
            }
            case "ECDHEPSK": 
            case "kECDEHPSK": {
                return CipherSuitePredicate.matchKeyAgreement(KeyAgreement.ECDHEPSK);
            }
        }
        MechanismDatabase database = MechanismDatabase.getInstance();
        MechanismDatabase.Entry entry = database.getCipherSuiteOpenSSLName(word);
        if (entry == null) {
            entry = database.getCipherSuite(word);
        }
        if (entry == null) {
            return null;
        }
        return CipherSuitePredicate.matchName(word);
    }

    static final class SortByAlgorithmKeyLengthCipherSuiteSelector
    extends CipherSuiteSelector {
        SortByAlgorithmKeyLengthCipherSuiteSelector(CipherSuiteSelector prev) {
            super(prev);
        }

        @Override
        void applyFilter(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
            if (!enabled.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>(enabled);
                Collections.sort(list, (o1, o2) -> {
                    MechanismDatabase database = MechanismDatabase.getInstance();
                    MechanismDatabase.Entry e1 = database.getCipherSuite((String)o1);
                    MechanismDatabase.Entry e2 = database.getCipherSuite((String)o2);
                    return Integer.signum(e1.getAlgorithmBits() - e2.getAlgorithmBits());
                });
                enabled.clear();
                enabled.addAll(list);
            }
        }
    }

    static final class PushToEndCipherSuiteSelector
    extends CipherSuiteSelector {
        private final CipherSuitePredicate predicate;

        PushToEndCipherSuiteSelector(CipherSuiteSelector next, CipherSuitePredicate predicate) {
            super(next);
            this.predicate = predicate;
        }

        @Override
        void applyFilter(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
            MechanismDatabase database = MechanismDatabase.getInstance();
            Iterator<String> iterator = enabled.iterator();
            ArrayList<String> pushed = null;
            while (iterator.hasNext()) {
                String name = iterator.next();
                MechanismDatabase.Entry entry = database.getCipherSuite(name);
                if (!this.predicate.test(entry)) continue;
                if (pushed == null) {
                    pushed = new ArrayList<String>();
                }
                pushed.add(name);
                iterator.remove();
            }
            if (pushed != null) {
                enabled.addAll(pushed);
            }
        }
    }

    static final class FullyDeletingCipherSuiteSelector
    extends CipherSuiteSelector {
        private final CipherSuitePredicate predicate;

        FullyDeletingCipherSuiteSelector(CipherSuiteSelector next, CipherSuitePredicate predicate) {
            super(next);
            this.predicate = predicate;
        }

        @Override
        void applyFilter(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
            Iterator<Map.Entry<MechanismDatabase.Entry, String>> iterator = supported.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<MechanismDatabase.Entry, String> item = iterator.next();
                if (!this.predicate.test(item.getKey())) continue;
                iterator.remove();
                enabled.remove(item.getValue());
            }
        }
    }

    static final class RemovingCipherSuiteSelector
    extends CipherSuiteSelector {
        private final CipherSuitePredicate predicate;

        RemovingCipherSuiteSelector(CipherSuiteSelector next, CipherSuitePredicate predicate) {
            super(next);
            this.predicate = predicate;
        }

        @Override
        void applyFilter(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
            for (Map.Entry<MechanismDatabase.Entry, String> item : supported.entrySet()) {
                if (!this.predicate.test(item.getKey())) continue;
                enabled.remove(item.getValue());
            }
        }
    }

    static final class AddingCipherSuiteSelector
    extends CipherSuiteSelector {
        private final CipherSuitePredicate predicate;

        AddingCipherSuiteSelector(CipherSuiteSelector next, CipherSuitePredicate predicate) {
            super(next);
            this.predicate = predicate;
        }

        @Override
        void applyFilter(Set<String> enabled, Map<MechanismDatabase.Entry, String> supported) {
            for (Map.Entry<MechanismDatabase.Entry, String> item : supported.entrySet()) {
                if (!this.predicate.test(item.getKey())) continue;
                enabled.add(item.getValue());
            }
        }
    }
}

