/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.EnumSet;

public enum Digest {
    MD5,
    SHA1,
    GOST94,
    GOST89MAC,
    SHA256,
    SHA384,
    AEAD;

    static final int fullSize;

    static Digest forName(String name) {
        switch (name) {
            case "MD5": {
                return MD5;
            }
            case "SHA1": {
                return SHA1;
            }
            case "GOST94": {
                return GOST94;
            }
            case "GOST89MAC": {
                return GOST89MAC;
            }
            case "SHA256": {
                return SHA256;
            }
            case "SHA384": {
                return SHA384;
            }
            case "AEAD": {
                return AEAD;
            }
        }
        return null;
    }

    public static boolean isFull(EnumSet<Digest> digests) {
        return digests != null && digests.size() == fullSize;
    }

    public boolean in(Digest value1, Digest value2) {
        return this == value1 || this == value2;
    }

    public boolean in(Digest value1, Digest value2, Digest value3) {
        return this == value1 || this == value2 || this == value3;
    }

    public boolean in(Digest ... values) {
        if (values != null) {
            for (Digest value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = Digest.values().length;
    }
}

