/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.EnumSet;

public enum Protocol {
    SSLv2,
    SSLv3,
    TLSv1,
    TLSv1_1,
    TLSv1_2,
    TLSv1_3;

    static final int fullSize;

    static Protocol forName(String name) {
        switch (name) {
            case "SSLv2": {
                return SSLv2;
            }
            case "SSLv3": {
                return SSLv3;
            }
            case "TLSv1": {
                return TLSv1;
            }
            case "TLSv1.1": {
                return TLSv1_1;
            }
            case "TLSv1.2": {
                return TLSv1_2;
            }
            case "TLSv1.3": {
                return TLSv1_3;
            }
        }
        return null;
    }

    public static boolean isFull(EnumSet<Protocol> protocols) {
        return protocols != null && protocols.size() == fullSize;
    }

    public boolean in(Protocol value1, Protocol value2) {
        return this == value1 || this == value2;
    }

    public boolean in(Protocol value1, Protocol value2, Protocol value3) {
        return this == value1 || this == value2 || this == value3;
    }

    public boolean in(Protocol ... values) {
        if (values != null) {
            for (Protocol value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = Protocol.values().length;
    }
}

