/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.ssl;

import java.util.EnumSet;
import org.shaded.wildfly.security.ssl.CipherSuitePredicate;
import org.shaded.wildfly.security.ssl.MechanismDatabase;
import org.shaded.wildfly.security.ssl.Protocol;

final class ProtocolCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<Protocol> set;

    ProtocolCipherSuitePredicate(EnumSet<Protocol> set) {
        this.set = set;
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getProtocol());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Protocol.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

