/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.wildfly.security.util;

import java.util.NoSuchElementException;
import org.shaded.wildfly.security._private.ElytronMessages;
import org.shaded.wildfly.security.util.Alphabet;
import org.shaded.wildfly.security.util.ByteIterator;

abstract class NumericIterator {
    NumericIterator() {
    }

    public abstract boolean hasNext();

    public abstract boolean hasPrev();

    public abstract int next() throws NoSuchElementException;

    public abstract int peekNext() throws NoSuchElementException;

    public abstract int prev() throws NoSuchElementException;

    public abstract int peekPrev() throws NoSuchElementException;

    public ByteIterator base64Decode(final Alphabet.Base64Alphabet alphabet, boolean requirePadding) {
        if (!this.hasNext()) {
            return ByteIterator.EMPTY;
        }
        if (alphabet.littleEndian) {
            return new Base64ByteIterator(this, requirePadding){
                {
                    NumericIterator numericIterator = x0;
                    numericIterator.getClass();
                    super(requirePadding);
                }

                @Override
                int calc0(int b0, int b1) {
                    int d0 = alphabet.decode(b0);
                    int d1 = alphabet.decode(b1);
                    if (d0 == -1 || d1 == -1) {
                        throw ElytronMessages.log.invalidBase64Character();
                    }
                    return (d0 | d1 << 6) & 0xFF;
                }

                @Override
                int calc1(int b1, int b2) {
                    int d1 = alphabet.decode(b1);
                    int d2 = alphabet.decode(b2);
                    if (d1 == -1 || d2 == -1) {
                        throw ElytronMessages.log.invalidBase64Character();
                    }
                    return (d1 >> 2 | d2 << 4) & 0xFF;
                }

                @Override
                int calc2(int b2, int b3) {
                    int d2 = alphabet.decode(b2);
                    int d3 = alphabet.decode(b3);
                    if (d2 == -1 || d3 == -1) {
                        throw ElytronMessages.log.invalidBase64Character();
                    }
                    return (d2 >> 4 | d3 << 2) & 0xFF;
                }
            };
        }
        return new Base64ByteIterator(this, requirePadding){
            {
                NumericIterator numericIterator = x0;
                numericIterator.getClass();
                super(requirePadding);
            }

            @Override
            int calc0(int b0, int b1) {
                int d0 = alphabet.decode(b0);
                int d1 = alphabet.decode(b1);
                if (d0 == -1 || d1 == -1) {
                    throw ElytronMessages.log.invalidBase64Character();
                }
                return (d0 << 2 | d1 >> 4) & 0xFF;
            }

            @Override
            int calc1(int b1, int b2) {
                int d1 = alphabet.decode(b1);
                int d2 = alphabet.decode(b2);
                if (d1 == -1 || d2 == -1) {
                    throw ElytronMessages.log.invalidBase64Character();
                }
                return (d1 << 4 | d2 >> 2) & 0xFF;
            }

            @Override
            int calc2(int b2, int b3) {
                int d2 = alphabet.decode(b2);
                int d3 = alphabet.decode(b3);
                if (d2 == -1 || d3 == -1) {
                    throw ElytronMessages.log.invalidBase64Character();
                }
                return (d2 << 6 | d3) & 0xFF;
            }
        };
    }

    public ByteIterator base32Decode(final Alphabet.Base32Alphabet alphabet, boolean requirePadding) {
        if (!this.hasNext()) {
            return ByteIterator.EMPTY;
        }
        if (alphabet.littleEndian) {
            return new Base32ByteIterator(this, requirePadding){
                {
                    NumericIterator numericIterator = x0;
                    numericIterator.getClass();
                    super(requirePadding);
                }

                @Override
                int calc0(int b0, int b1) {
                    int d0 = alphabet.decode(b0);
                    int d1 = alphabet.decode(b1);
                    if (d0 == -1 || d1 == -1) {
                        throw ElytronMessages.log.invalidBase32Character();
                    }
                    return (d0 | d1 << 5) & 0xFF;
                }

                @Override
                int calc1(int b1, int b2, int b3) {
                    int d1 = alphabet.decode(b1);
                    int d2 = alphabet.decode(b2);
                    int d3 = alphabet.decode(b3);
                    if (d1 == -1 || d2 == -1 || d3 == -1) {
                        throw ElytronMessages.log.invalidBase32Character();
                    }
                    return (d1 >> 3 | d2 << 2 | d3 << 7) & 0xFF;
                }

                @Override
                int calc2(int b3, int b4) {
                    int d3 = alphabet.decode(b3);
                    int d4 = alphabet.decode(b4);
                    if (d3 == -1 || d4 == -1) {
                        throw ElytronMessages.log.invalidBase32Character();
                    }
                    return (d3 >> 1 | d4 << 4) & 0xFF;
                }

                @Override
                int calc3(int b4, int b5, int b6) {
                    int d4 = alphabet.decode(b4);
                    int d5 = alphabet.decode(b5);
                    int d6 = alphabet.decode(b6);
                    if (d4 == -1 || d5 == -1 || d6 == -1) {
                        throw ElytronMessages.log.invalidBase32Character();
                    }
                    return (d4 >> 4 | d5 << 1 | d6 << 6) & 0xFF;
                }

                @Override
                int calc4(int b6, int b7) {
                    int d6 = alphabet.decode(b6);
                    int d7 = alphabet.decode(b7);
                    if (d6 == -1 || d7 == -1) {
                        throw ElytronMessages.log.invalidBase32Character();
                    }
                    return (d6 >> 2 | d7 << 3) & 0xFF;
                }
            };
        }
        return new Base32ByteIterator(this, requirePadding){
            {
                NumericIterator numericIterator = x0;
                numericIterator.getClass();
                super(requirePadding);
            }

            @Override
            int calc0(int b0, int b1) {
                int d0 = alphabet.decode(b0);
                int d1 = alphabet.decode(b1);
                if (d0 == -1 || d1 == -1) {
                    throw ElytronMessages.log.invalidBase32Character();
                }
                return (d0 << 3 | d1 >> 2) & 0xFF;
            }

            @Override
            int calc1(int b1, int b2, int b3) {
                int d1 = alphabet.decode(b1);
                int d2 = alphabet.decode(b2);
                int d3 = alphabet.decode(b3);
                if (d1 == -1 || d2 == -1 || d3 == -1) {
                    throw ElytronMessages.log.invalidBase32Character();
                }
                return (d1 << 6 | d2 << 1 | d3 >> 4) & 0xFF;
            }

            @Override
            int calc2(int b3, int b4) {
                int d3 = alphabet.decode(b3);
                int d4 = alphabet.decode(b4);
                if (d3 == -1 || d4 == -1) {
                    throw ElytronMessages.log.invalidBase32Character();
                }
                return (d3 << 4 | d4 >> 1) & 0xFF;
            }

            @Override
            int calc3(int b4, int b5, int b6) {
                int d4 = alphabet.decode(b4);
                int d5 = alphabet.decode(b5);
                int d6 = alphabet.decode(b6);
                if (d4 == -1 || d5 == -1 || d6 == -1) {
                    throw ElytronMessages.log.invalidBase32Character();
                }
                return (d4 << 7 | d5 << 2 | d6 >> 3) & 0xFF;
            }

            @Override
            int calc4(int b6, int b7) {
                int d6 = alphabet.decode(b6);
                int d7 = alphabet.decode(b7);
                if (d6 == -1 || d7 == -1) {
                    throw ElytronMessages.log.invalidBase32Character();
                }
                return (d6 << 5 | d7) & 0xFF;
            }
        };
    }

    public ByteIterator hexDecode() {
        if (!this.hasNext()) {
            return ByteIterator.EMPTY;
        }
        return new ByteIterator(){
            private int b;
            private int offset;
            private boolean havePair;

            private int calc(int b0, int b1) {
                int d0 = Character.digit(b0, 16);
                int d1 = Character.digit(b1, 16);
                if (d0 == -1 || d1 == -1) {
                    throw ElytronMessages.log.invalidHexCharacter();
                }
                return (d0 << 4 | d1) & 0xFF;
            }

            @Override
            public boolean hasNext() {
                if (this.havePair) {
                    return true;
                }
                if (!NumericIterator.this.hasNext()) {
                    return false;
                }
                int b0 = NumericIterator.this.next();
                if (!NumericIterator.this.hasNext()) {
                    throw ElytronMessages.log.expectedEvenNumberOfHexCharacters();
                }
                int b1 = NumericIterator.this.next();
                this.b = this.calc(b0, b1);
                this.havePair = true;
                return true;
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            @Override
            public int next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.offset;
                this.havePair = false;
                return this.b;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.b;
            }

            @Override
            public int prev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                int b1 = NumericIterator.this.prev();
                int b0 = NumericIterator.this.prev();
                this.b = this.calc(b0, b1);
                --this.offset;
                this.havePair = true;
                return this.b;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                int b1 = NumericIterator.this.prev();
                int b0 = NumericIterator.this.peekPrev();
                NumericIterator.this.next();
                return this.calc(b0, b1);
            }

            @Override
            public int offset() {
                return this.offset;
            }
        };
    }

    abstract class Base32ByteIterator
    extends ByteIterator {
        private final boolean requirePadding;
        private int state = 0;
        private int o0;
        private int o1;
        private int o2;
        private int o3;
        private int o4;
        private int offset;

        protected Base32ByteIterator(boolean requirePadding) {
            this.requirePadding = requirePadding;
        }

        @Override
        public boolean hasNext() {
            if (this.state == 0) {
                if (!NumericIterator.this.hasNext()) {
                    return false;
                }
                int b0 = NumericIterator.this.next();
                if (b0 == 61) {
                    throw ElytronMessages.log.unexpectedPadding();
                }
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    throw ElytronMessages.log.incompleteDecode();
                }
                int b1 = NumericIterator.this.next();
                if (b1 == 61) {
                    throw ElytronMessages.log.unexpectedPadding();
                }
                this.o0 = this.calc0(b0, b1);
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    this.state = 25;
                    return true;
                }
                int b2 = NumericIterator.this.next();
                if (b2 == 61) {
                    for (int i = 0; i < 5; ++i) {
                        if (!NumericIterator.this.hasNext()) {
                            throw ElytronMessages.log.expectedPaddingCharacters(6);
                        }
                        if (NumericIterator.this.next() == 61) continue;
                        throw ElytronMessages.log.expectedPaddingCharacters(6);
                    }
                    this.state = 15;
                    return true;
                }
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    throw ElytronMessages.log.incompleteDecode();
                }
                int b3 = NumericIterator.this.next();
                if (b3 == 61) {
                    throw ElytronMessages.log.unexpectedPadding();
                }
                this.o1 = this.calc1(b1, b2, b3);
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    this.state = 23;
                    return true;
                }
                int b4 = NumericIterator.this.next();
                if (b4 == 61) {
                    for (int i = 0; i < 3; ++i) {
                        if (!NumericIterator.this.hasNext()) {
                            throw ElytronMessages.log.expectedPaddingCharacters(4);
                        }
                        if (NumericIterator.this.next() == 61) continue;
                        throw ElytronMessages.log.expectedPaddingCharacters(4);
                    }
                    this.state = 13;
                    return true;
                }
                this.o2 = this.calc2(b3, b4);
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    this.state = 20;
                    return true;
                }
                int b5 = NumericIterator.this.next();
                if (b5 == 61) {
                    for (int i = 0; i < 2; ++i) {
                        if (!NumericIterator.this.hasNext()) {
                            throw ElytronMessages.log.expectedPaddingCharacters(3);
                        }
                        if (NumericIterator.this.next() == 61) continue;
                        throw ElytronMessages.log.expectedPaddingCharacters(3);
                    }
                    this.state = 10;
                    return true;
                }
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    throw ElytronMessages.log.incompleteDecode();
                }
                int b6 = NumericIterator.this.next();
                if (b6 == 61) {
                    throw ElytronMessages.log.unexpectedPadding();
                }
                this.o3 = this.calc3(b4, b5, b6);
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    this.state = 16;
                    return true;
                }
                int b7 = NumericIterator.this.next();
                if (b7 == 61) {
                    this.state = 6;
                    return true;
                }
                this.o4 = this.calc4(b6, b7);
                this.state = 1;
                return true;
            }
            return this.state < 26;
        }

        @Override
        public boolean hasPrev() {
            return this.offset > 0;
        }

        abstract int calc0(int var1, int var2);

        abstract int calc1(int var1, int var2, int var3);

        abstract int calc2(int var1, int var2);

        abstract int calc3(int var1, int var2, int var3);

        abstract int calc4(int var1, int var2);

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 1: 
                case 6: 
                case 10: 
                case 13: 
                case 16: 
                case 20: 
                case 23: {
                    ++this.state;
                    ++this.offset;
                    return this.o0;
                }
                case 2: 
                case 7: 
                case 11: 
                case 17: 
                case 21: {
                    ++this.state;
                    ++this.offset;
                    return this.o1;
                }
                case 3: 
                case 8: 
                case 18: {
                    ++this.state;
                    ++this.offset;
                    return this.o2;
                }
                case 4: {
                    this.state = 5;
                    ++this.offset;
                    return this.o3;
                }
                case 5: {
                    this.state = 0;
                    ++this.offset;
                    return this.o4;
                }
                case 9: {
                    this.state = 26;
                    ++this.offset;
                    return this.o3;
                }
                case 12: {
                    this.state = 27;
                    ++this.offset;
                    return this.o2;
                }
                case 14: {
                    this.state = 28;
                    ++this.offset;
                    return this.o1;
                }
                case 15: {
                    this.state = 29;
                    ++this.offset;
                    return this.o0;
                }
                case 19: {
                    this.state = 30;
                    ++this.offset;
                    return this.o3;
                }
                case 22: {
                    this.state = 31;
                    ++this.offset;
                    return this.o2;
                }
                case 24: {
                    this.state = 32;
                    ++this.offset;
                    return this.o1;
                }
                case 25: {
                    this.state = 33;
                    ++this.offset;
                    return this.o0;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int peekNext() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 1: 
                case 6: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 20: 
                case 23: 
                case 25: {
                    return this.o0;
                }
                case 2: 
                case 7: 
                case 11: 
                case 14: 
                case 17: 
                case 21: 
                case 24: {
                    return this.o1;
                }
                case 3: 
                case 8: 
                case 12: 
                case 18: 
                case 22: {
                    return this.o2;
                }
                case 4: 
                case 9: 
                case 19: {
                    return this.o3;
                }
                case 5: {
                    return this.o4;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int prev() {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            int skipChars = 0;
            switch (this.state) {
                case 0: 
                case 1: 
                case 6: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 20: 
                case 23: 
                case 25: {
                    if (this.state == 6 || this.state == 10 || this.state == 13 || this.state == 15) {
                        skipChars = 8;
                    } else if (this.state == 16) {
                        skipChars = 7;
                    } else if (this.state == 20) {
                        skipChars = 5;
                    } else if (this.state == 23) {
                        skipChars = 4;
                    } else if (this.state == 25) {
                        skipChars = 2;
                    }
                    for (int i = 0; i < skipChars; ++i) {
                        NumericIterator.this.prev();
                    }
                    int b7 = NumericIterator.this.prev();
                    int b6 = NumericIterator.this.prev();
                    int b5 = NumericIterator.this.prev();
                    int b4 = NumericIterator.this.prev();
                    int b3 = NumericIterator.this.prev();
                    int b2 = NumericIterator.this.prev();
                    int b1 = NumericIterator.this.prev();
                    int b0 = NumericIterator.this.prev();
                    this.o0 = this.calc0(b0, b1);
                    this.o1 = this.calc1(b1, b2, b3);
                    this.o2 = this.calc2(b3, b4);
                    this.o3 = this.calc3(b4, b5, b6);
                    this.o4 = this.calc4(b6, b7);
                    this.state = 5;
                    --this.offset;
                    return this.o4;
                }
                case 2: 
                case 7: 
                case 11: 
                case 14: 
                case 17: 
                case 21: 
                case 24: {
                    --this.state;
                    --this.offset;
                    return this.o0;
                }
                case 3: 
                case 8: 
                case 12: 
                case 18: 
                case 22: {
                    --this.state;
                    --this.offset;
                    return this.o1;
                }
                case 4: 
                case 9: 
                case 19: {
                    --this.state;
                    --this.offset;
                    return this.o2;
                }
                case 5: {
                    this.state = 4;
                    --this.offset;
                    return this.o3;
                }
                case 26: {
                    this.state = 9;
                    --this.offset;
                    return this.o3;
                }
                case 27: {
                    this.state = 12;
                    --this.offset;
                    return this.o2;
                }
                case 28: {
                    this.state = 14;
                    --this.offset;
                    return this.o1;
                }
                case 29: {
                    this.state = 15;
                    --this.offset;
                    return this.o0;
                }
                case 30: {
                    this.state = 19;
                    --this.offset;
                    return this.o3;
                }
                case 31: {
                    this.state = 22;
                    --this.offset;
                    return this.o2;
                }
                case 32: {
                    this.state = 24;
                    --this.offset;
                    return this.o1;
                }
                case 33: {
                    this.state = 25;
                    --this.offset;
                    return this.o0;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int peekPrev() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            int skipChars = 0;
            switch (this.state) {
                case 0: 
                case 1: 
                case 6: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 20: 
                case 23: 
                case 25: {
                    if (this.state == 6 || this.state == 10 || this.state == 13 || this.state == 15) {
                        skipChars = 8;
                    } else if (this.state == 16) {
                        skipChars = 7;
                    } else if (this.state == 20) {
                        skipChars = 5;
                    } else if (this.state == 23) {
                        skipChars = 4;
                    } else if (this.state == 25) {
                        skipChars = 2;
                    }
                    for (int i = 0; i < skipChars; ++i) {
                        NumericIterator.this.prev();
                    }
                    int b7 = NumericIterator.this.prev();
                    int b6 = NumericIterator.this.peekPrev();
                    NumericIterator.this.next();
                    for (int i = 0; i < skipChars; ++i) {
                        NumericIterator.this.next();
                    }
                    return this.calc4(b6, b7);
                }
                case 2: 
                case 7: 
                case 11: 
                case 14: 
                case 17: 
                case 21: 
                case 24: 
                case 29: 
                case 33: {
                    return this.o0;
                }
                case 3: 
                case 8: 
                case 12: 
                case 18: 
                case 22: 
                case 28: 
                case 32: {
                    return this.o1;
                }
                case 4: 
                case 9: 
                case 19: 
                case 27: 
                case 31: {
                    return this.o2;
                }
                case 5: 
                case 26: 
                case 30: {
                    return this.o3;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int offset() {
            return this.offset;
        }
    }

    abstract class Base64ByteIterator
    extends ByteIterator {
        private final boolean requirePadding;
        private int state = 0;
        private int o0;
        private int o1;
        private int o2;
        private int offset;

        protected Base64ByteIterator(boolean requirePadding) {
            this.requirePadding = requirePadding;
        }

        @Override
        public boolean hasNext() {
            if (this.state == 0) {
                if (!NumericIterator.this.hasNext()) {
                    return false;
                }
                int b0 = NumericIterator.this.next();
                if (b0 == 61) {
                    throw ElytronMessages.log.unexpectedPadding();
                }
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        throw ElytronMessages.log.expectedPadding();
                    }
                    throw ElytronMessages.log.incompleteDecode();
                }
                int b1 = NumericIterator.this.next();
                if (b1 == 61) {
                    throw ElytronMessages.log.unexpectedPadding();
                }
                this.o0 = this.calc0(b0, b1);
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        ElytronMessages.log.expectedPadding();
                    }
                    this.state = 9;
                    return true;
                }
                int b2 = NumericIterator.this.next();
                if (b2 == 61) {
                    if (!NumericIterator.this.hasNext()) {
                        throw ElytronMessages.log.expectedTwoPaddingCharacters();
                    }
                    if (NumericIterator.this.next() != 61) {
                        throw ElytronMessages.log.expectedTwoPaddingCharacters();
                    }
                    this.state = 6;
                    return true;
                }
                this.o1 = this.calc1(b1, b2);
                if (!NumericIterator.this.hasNext()) {
                    if (this.requirePadding) {
                        ElytronMessages.log.expectedPadding();
                    }
                    this.state = 7;
                    return true;
                }
                int b3 = NumericIterator.this.next();
                if (b3 == 61) {
                    this.state = 4;
                    return true;
                }
                this.o2 = this.calc2(b2, b3);
                this.state = 1;
                return true;
            }
            return this.state < 10;
        }

        @Override
        public boolean hasPrev() {
            return this.state != 0 || this.offset > 0;
        }

        abstract int calc0(int var1, int var2);

        abstract int calc1(int var1, int var2);

        abstract int calc2(int var1, int var2);

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 1: {
                    this.state = 2;
                    ++this.offset;
                    return this.o0;
                }
                case 2: {
                    this.state = 3;
                    ++this.offset;
                    return this.o1;
                }
                case 3: {
                    this.state = 0;
                    ++this.offset;
                    return this.o2;
                }
                case 4: {
                    this.state = 5;
                    ++this.offset;
                    return this.o0;
                }
                case 5: {
                    this.state = 11;
                    ++this.offset;
                    return this.o1;
                }
                case 6: {
                    this.state = 10;
                    ++this.offset;
                    return this.o0;
                }
                case 7: {
                    this.state = 8;
                    ++this.offset;
                    return this.o0;
                }
                case 8: {
                    this.state = 13;
                    ++this.offset;
                    return this.o1;
                }
                case 9: {
                    this.state = 12;
                    ++this.offset;
                    return this.o0;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int peekNext() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 9: {
                    return this.o0;
                }
                case 2: 
                case 5: 
                case 8: {
                    return this.o1;
                }
                case 3: {
                    return this.o2;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int prev() {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 6: {
                    NumericIterator.this.prev();
                }
                case 4: {
                    NumericIterator.this.prev();
                }
                case 0: 
                case 1: 
                case 7: 
                case 9: {
                    int b3 = NumericIterator.this.prev();
                    int b2 = NumericIterator.this.prev();
                    int b1 = NumericIterator.this.prev();
                    int b0 = NumericIterator.this.prev();
                    this.o0 = this.calc0(b0, b1);
                    this.o1 = this.calc1(b1, b2);
                    this.state = 3;
                    --this.offset;
                    this.o2 = this.calc2(b2, b3);
                    return this.o2;
                }
                case 2: {
                    this.state = 1;
                    --this.offset;
                    return this.o0;
                }
                case 3: {
                    this.state = 2;
                    --this.offset;
                    return this.o1;
                }
                case 5: {
                    this.state = 4;
                    --this.offset;
                    return this.o0;
                }
                case 8: {
                    this.state = 7;
                    --this.offset;
                    return this.o0;
                }
                case 10: {
                    this.state = 6;
                    --this.offset;
                    return this.o0;
                }
                case 11: {
                    this.state = 5;
                    --this.offset;
                    return this.o1;
                }
                case 12: {
                    this.state = 9;
                    --this.offset;
                    return this.o0;
                }
                case 13: {
                    this.state = 8;
                    --this.offset;
                    return this.o1;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int peekPrev() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 6: {
                    NumericIterator.this.prev();
                }
                case 4: {
                    NumericIterator.this.prev();
                }
                case 0: 
                case 1: 
                case 7: 
                case 9: {
                    int b3 = NumericIterator.this.prev();
                    int b2 = NumericIterator.this.peekPrev();
                    NumericIterator.this.next();
                    if (this.state == 4) {
                        NumericIterator.this.next();
                    } else if (this.state == 6) {
                        NumericIterator.this.next();
                        NumericIterator.this.next();
                    }
                    return this.calc2(b2, b3);
                }
                case 2: {
                    return this.o0;
                }
                case 3: {
                    return this.o1;
                }
                case 5: {
                    return this.o0;
                }
                case 8: {
                    return this.o0;
                }
                case 10: {
                    return this.o0;
                }
                case 11: {
                    return this.o1;
                }
                case 12: {
                    return this.o0;
                }
                case 13: {
                    return this.o1;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public int offset() {
            return this.offset;
        }
    }
}

