/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.shaded.json.Json;
import javax.shaded.json.JsonArrayBuilder;
import javax.shaded.json.JsonBuilderFactory;
import javax.shaded.json.JsonObject;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.json.NullAwareJsonObjectBuilder;
import oshi.software.os.OSProcess;
import oshi.util.ParseUtil;

public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    private final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private double lastCpuLoad = 0.0;
    private long lastCpuLoadTime = 0L;
    private boolean sunMXBean;
    protected int logicalProcessorCount;
    protected int physicalProcessorCount;
    protected long tickTime;
    protected long[] prevTicks;
    protected long[] curTicks;
    protected long procTickTime;
    protected long[][] prevProcTicks;
    protected long[][] curProcTicks;
    protected String cpuVendor;
    protected String cpuName;
    protected String cpuSerialNumber;
    protected String cpuIdentifier;
    protected String cpuStepping;
    protected String cpuModel;
    protected String cpuFamily;
    protected Long cpuVendorFreq;
    protected Boolean cpu64;
    protected JsonBuilderFactory jsonFactory;

    public AbstractCentralProcessor() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            this.lastCpuLoad = ((OperatingSystemMXBean)this.OS_MXBEAN).getSystemCpuLoad();
            this.lastCpuLoadTime = System.currentTimeMillis();
            this.sunMXBean = true;
            LOG.debug("Oracle MXBean detected.");
        }
        catch (ClassNotFoundException e) {
            this.sunMXBean = false;
            LOG.debug("Oracle MXBean not detected.");
            LOG.trace("", e);
        }
        this.logicalProcessorCount = 0;
        this.physicalProcessorCount = 0;
        this.cpuSerialNumber = null;
        this.jsonFactory = Json.createBuilderFactory(null);
        this.calculateProcessorCounts();
    }

    protected synchronized void initTicks() {
        this.prevTicks = new long[4];
        this.curTicks = new long[4];
        this.updateSystemTicks();
        this.prevProcTicks = new long[this.logicalProcessorCount][4];
        this.curProcTicks = new long[this.logicalProcessorCount][4];
        this.updateProcessorTicks();
    }

    protected abstract void calculateProcessorCounts();

    @Override
    public String getVendor() {
        if (this.cpuVendor == null) {
            this.setVendor("");
        }
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        if (this.cpuName == null) {
            this.setName("");
        }
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        if (this.cpuIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getVendor().contentEquals("GenuineIntel")) {
                sb.append(this.isCpu64bit() ? "Intel64" : "x86");
            } else {
                sb.append(this.getVendor());
            }
            sb.append(" Family ").append(this.getFamily());
            sb.append(" Model ").append(this.getModel());
            sb.append(" Stepping ").append(this.getStepping());
            this.setIdentifier(sb.toString());
        }
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        if (this.cpu64 == null) {
            this.setCpu64(false);
        }
        return this.cpu64;
    }

    @Override
    public void setCpu64(boolean value) {
        this.cpu64 = value;
    }

    @Override
    public String getStepping() {
        if (this.cpuStepping == null) {
            this.setStepping(this.parseIdentifier("Stepping"));
        }
        return this.cpuStepping;
    }

    @Override
    public void setStepping(String stepping) {
        this.cpuStepping = stepping;
    }

    @Override
    public String getModel() {
        if (this.cpuModel == null) {
            this.setModel(this.parseIdentifier("Model"));
        }
        return this.cpuModel;
    }

    @Override
    public void setModel(String model) {
        this.cpuModel = model;
    }

    @Override
    public String getFamily() {
        if (this.cpuFamily == null) {
            this.setFamily(this.parseIdentifier("Family"));
        }
        return this.cpuFamily;
    }

    @Override
    public void setFamily(String family) {
        this.cpuFamily = family;
    }

    private String parseIdentifier(String id) {
        String[] idSplit = this.getIdentifier().split("\\s+");
        boolean found = false;
        for (String s : idSplit) {
            if (found) {
                return s;
            }
            found = s.equals(id);
        }
        return "";
    }

    @Override
    public synchronized double getSystemCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)this.tickTime);
        if (now - this.tickTime > 950L) {
            this.updateSystemTicks();
        }
        long total = 0L;
        for (int i = 0; i < this.curTicks.length; ++i) {
            total += this.curTicks[i] - this.prevTicks[i];
        }
        long idle = this.curTicks[3] - this.prevTicks[3];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    @Override
    public abstract long[] getSystemCpuLoadTicks();

    @Override
    public abstract long getSystemIOWaitTicks();

    @Override
    public abstract long[] getSystemIrqTicks();

    protected void updateSystemTicks() {
        LOG.trace("Updating System Ticks");
        System.arraycopy(this.curTicks, 0, this.prevTicks, 0, this.curTicks.length);
        this.tickTime = System.currentTimeMillis();
        long[] ticks = this.getSystemCpuLoadTicks();
        System.arraycopy(ticks, 0, this.curTicks, 0, ticks.length);
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.sunMXBean) {
            long now = System.currentTimeMillis();
            if (now - this.lastCpuLoadTime < 200L) {
                return this.lastCpuLoad;
            }
            this.lastCpuLoad = ((OperatingSystemMXBean)this.OS_MXBEAN).getSystemCpuLoad();
            this.lastCpuLoadTime = now;
            return this.lastCpuLoad;
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return this.getSystemLoadAverage(1)[0];
    }

    @Override
    public abstract double[] getSystemLoadAverage(int var1);

    @Override
    public double[] getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)this.procTickTime);
        if (now - this.procTickTime > 950L) {
            this.updateProcessorTicks();
        }
        double[] load = new double[this.logicalProcessorCount];
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long total = 0L;
            for (int i = 0; i < this.curProcTicks[cpu].length; ++i) {
                total += this.curProcTicks[cpu][i] - this.prevProcTicks[cpu][i];
            }
            long idle = this.curProcTicks[cpu][3] - this.prevProcTicks[cpu][3];
            LOG.trace("CPU: {}  Total ticks: {}  Idle ticks: {}", cpu, total, idle);
            load[cpu] = total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
        }
        return load;
    }

    @Override
    public abstract long[][] getProcessorCpuLoadTicks();

    protected void updateProcessorTicks() {
        LOG.trace("Updating Processor Ticks");
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            System.arraycopy(this.curProcTicks[cpu], 0, this.prevProcTicks[cpu], 0, this.curProcTicks[cpu].length);
        }
        this.procTickTime = System.currentTimeMillis();
        long[][] ticks = this.getProcessorCpuLoadTicks();
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            System.arraycopy(ticks[cpu], 0, this.curProcTicks[cpu], 0, ticks[cpu].length);
        }
    }

    @Override
    public abstract long getSystemUptime();

    @Override
    public abstract String getSystemSerialNumber();

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    @Override
    public abstract int getProcessCount();

    @Override
    public abstract int getThreadCount();

    @Override
    public JsonObject toJSON() {
        JsonArrayBuilder systemLoadAverageArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (double avg : this.getSystemLoadAverage(3)) {
            systemLoadAverageArrayBuilder.add(avg);
        }
        JsonArrayBuilder systemCpuLoadTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (long ticks : this.getSystemCpuLoadTicks()) {
            systemCpuLoadTicksArrayBuilder.add(ticks);
        }
        JsonArrayBuilder processorCpuLoadBetweenTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (double load : this.getProcessorCpuLoadBetweenTicks()) {
            processorCpuLoadBetweenTicksArrayBuilder.add(load);
        }
        JsonArrayBuilder processorCpuLoadTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (long[] procTicks : this.getProcessorCpuLoadTicks()) {
            JsonArrayBuilder processorTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (long ticks : procTicks) {
                processorTicksArrayBuilder.add(ticks);
            }
            processorCpuLoadTicksArrayBuilder.add(processorTicksArrayBuilder.build());
        }
        JsonArrayBuilder systemIrqTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (long ticks : this.getSystemIrqTicks()) {
            systemIrqTicksArrayBuilder.add(ticks);
        }
        JsonArrayBuilder processArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (OSProcess proc : this.getProcesses()) {
            processArrayBuilder.add(proc.toJSON());
        }
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("name", this.getName()).add("physicalProcessorCount", this.getPhysicalProcessorCount()).add("logicalProcessorCount", this.getLogicalProcessorCount()).add("systemSerialNumber", this.getSystemSerialNumber()).add("vendor", this.getVendor()).add("vendorFreq", this.getVendorFreq()).add("cpu64bit", this.isCpu64bit()).add("family", this.getFamily()).add("model", this.getModel()).add("stepping", this.getStepping()).add("systemCpuLoadBetweenTicks", this.getSystemCpuLoadBetweenTicks()).add("systemCpuLoadTicks", systemCpuLoadTicksArrayBuilder.build()).add("systemCpuLoad", this.getSystemCpuLoad()).add("systemLoadAverage", this.getSystemLoadAverage()).add("systemLoadAverages", systemLoadAverageArrayBuilder.build()).add("systemIOWaitTicks", this.getSystemIOWaitTicks()).add("systemIrqTicks", systemIrqTicksArrayBuilder.build()).add("processorCpuLoadBetweenTicks", processorCpuLoadBetweenTicksArrayBuilder.build()).add("processorCpuLoadTicks", processorCpuLoadTicksArrayBuilder.build()).add("systemUptime", this.getSystemUptime()).add("processID", this.getProcessId()).add("processCount", this.getProcessCount()).add("threadCount", this.getThreadCount()).add("processes", processArrayBuilder.build()).build();
    }

    public String toString() {
        return this.getName();
    }
}

