/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.util.Arrays;
import javax.shaded.json.Json;
import javax.shaded.json.JsonBuilderFactory;
import javax.shaded.json.JsonObject;
import oshi.hardware.Display;
import oshi.json.NullAwareJsonObjectBuilder;
import oshi.util.EdidUtil;

public abstract class AbstractDisplay
implements Display {
    private static final long serialVersionUID = 1L;
    protected byte[] edid;
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    protected AbstractDisplay(byte[] edid) {
        this.edid = edid;
    }

    @Override
    public byte[] getEdid() {
        return Arrays.copyOf(this.edid, this.edid.length);
    }

    @Override
    public JsonObject toJSON() {
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("edid", EdidUtil.toString(this.getEdid())).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  Manuf. ID=").append(EdidUtil.getManufacturerID(this.edid)).append(", Product ID=").append(EdidUtil.getProductID(this.edid)).append(", ").append(EdidUtil.isDigital(this.edid) ? "Digital" : "Analog").append(", Serial=").append(EdidUtil.getSerialNo(this.edid)).append(", ManufDate=").append(EdidUtil.getWeek(this.edid) * 12 / 52 + 1 + "/").append(EdidUtil.getYear(this.edid)).append(", EDID v").append(EdidUtil.getVersion(this.edid));
        int hSize = EdidUtil.getHcm(this.edid);
        int vSize = EdidUtil.getVcm(this.edid);
        sb.append(String.format("%n  %d x %d cm (%.1f x %.1f in)", hSize, vSize, (double)hSize / 2.54, (double)vSize / 2.54));
        byte[][] desc = EdidUtil.getDescriptors(this.edid);
        block8: for (int d = 0; d < desc.length; ++d) {
            switch (EdidUtil.getDescriptorType(desc[d])) {
                case 255: {
                    sb.append("\n  Serial Number: ").append(EdidUtil.getDescriptorText(desc[d]));
                    continue block8;
                }
                case 254: {
                    sb.append("\n  Unspecified Text: ").append(EdidUtil.getDescriptorText(desc[d]));
                    continue block8;
                }
                case 253: {
                    sb.append("\n  Range Limits: ").append(EdidUtil.getDescriptorRangeLimits(desc[d]));
                    continue block8;
                }
                case 252: {
                    sb.append("\n  Monitor Name: ").append(EdidUtil.getDescriptorText(desc[d]));
                    continue block8;
                }
                case 251: {
                    sb.append("\n  White Point Data: ").append(EdidUtil.getDescriptorHex(desc[d]));
                    continue block8;
                }
                case 250: {
                    sb.append("\n  Standard Timing ID: ").append(EdidUtil.getDescriptorHex(desc[d]));
                    continue block8;
                }
                default: {
                    if (EdidUtil.getDescriptorType(desc[d]) <= 15 && EdidUtil.getDescriptorType(desc[d]) >= 0) {
                        sb.append("\n  Manufacturer Data: ").append(EdidUtil.getDescriptorHex(desc[d]));
                        continue block8;
                    }
                    sb.append("\n  Preferred Timing: ").append(EdidUtil.getTimingDescriptor(desc[d]));
                }
            }
        }
        return sb.toString();
    }
}

