/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import javax.shaded.json.Json;
import javax.shaded.json.JsonArrayBuilder;
import javax.shaded.json.JsonBuilderFactory;
import javax.shaded.json.JsonObject;
import oshi.hardware.CentralProcessor;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.UsbDevice;
import oshi.json.NullAwareJsonObjectBuilder;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;

public abstract class AbstractHardwareAbstractionLayer
implements HardwareAbstractionLayer {
    private static final long serialVersionUID = 1L;
    protected CentralProcessor processor;
    protected GlobalMemory memory;
    protected Sensors sensors;
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    @Override
    public abstract GlobalMemory getMemory();

    @Override
    public abstract CentralProcessor getProcessor();

    @Override
    public abstract PowerSource[] getPowerSources();

    @Override
    public abstract FileSystem getFileSystem();

    @Override
    public abstract OSFileStore[] getFileStores();

    @Override
    public abstract HWDiskStore[] getDiskStores();

    @Override
    public abstract Display[] getDisplays();

    @Override
    public abstract Sensors getSensors();

    @Override
    public abstract UsbDevice[] getUsbDevices();

    @Override
    public JsonObject toJSON() {
        JsonArrayBuilder powerSourceArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (PowerSource powerSource : this.getPowerSources()) {
            powerSourceArrayBuilder.add(powerSource.toJSON());
        }
        JsonArrayBuilder fileStoreArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (OSFileStore fileStore : this.getFileStores()) {
            fileStoreArrayBuilder.add(fileStore.toJSON());
        }
        JsonArrayBuilder diskStoreArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (HWDiskStore diskStore : this.getDiskStores()) {
            diskStoreArrayBuilder.add(diskStore.toJSON());
        }
        JsonArrayBuilder networkIFArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (NetworkIF netStore : this.getNetworkIFs()) {
            networkIFArrayBuilder.add(netStore.toJSON());
        }
        JsonArrayBuilder displayArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (Display display : this.getDisplays()) {
            displayArrayBuilder.add(display.toJSON());
        }
        JsonArrayBuilder usbDeviceArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (UsbDevice usbDevice : this.getUsbDevices()) {
            usbDeviceArrayBuilder.add(usbDevice.toJSON());
        }
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("processor", this.getProcessor().toJSON()).add("memory", this.getMemory().toJSON()).add("powerSources", powerSourceArrayBuilder.build()).add("fileSystem", this.getFileSystem().toJSON()).add("fileStores", fileStoreArrayBuilder.build()).add("disks", diskStoreArrayBuilder.build()).add("networks", networkIFArrayBuilder.build()).add("displays", displayArrayBuilder.build()).add("sensors", this.getSensors().toJSON()).add("usbDevices", usbDeviceArrayBuilder.build()).build();
    }
}

