/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.Libc;
import oshi.software.os.OSProcess;
import oshi.software.os.linux.LinuxProcess;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxCentralProcessor.class);

    public LinuxCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String line;
        String[] splitLine;
        List<String> cpuInfo = null;
        cpuInfo = FileUtil.readFile("/proc/cpuinfo");
        Iterator<String> iterator = cpuInfo.iterator();
        while (iterator.hasNext() && (splitLine = (line = iterator.next()).split("\\s+:\\s")).length >= 2) {
            switch (splitLine[0]) {
                case "vendor_id": {
                    this.setVendor(splitLine[1]);
                    break;
                }
                case "model name": {
                    this.setName(splitLine[1]);
                    break;
                }
                case "flags": {
                    String[] flags = splitLine[1].toUpperCase().split(" ");
                    boolean found = false;
                    for (String flag : flags) {
                        if (!flag.equals("LM")) continue;
                        found = true;
                        break;
                    }
                    this.setCpu64(found);
                    break;
                }
                case "stepping": {
                    this.setStepping(splitLine[1]);
                    break;
                }
                case "model": {
                    this.setModel(splitLine[1]);
                    break;
                }
                case "cpu family": {
                    this.setFamily(splitLine[1]);
                    break;
                }
            }
        }
    }

    @Override
    protected void calculateProcessorCounts() {
        List<String> procCpu = FileUtil.readFile("/proc/cpuinfo");
        for (String cpu : procCpu) {
            if (!cpu.startsWith("processor")) continue;
            ++this.logicalProcessorCount;
        }
        int siblings = 0;
        int cpucores = 0;
        int[] uniqueID = new int[]{-1, -1};
        HashSet<String> ids = new HashSet<String>();
        for (String cpu : procCpu) {
            if (cpu.startsWith("siblings") && (siblings = ParseUtil.parseLastInt(cpu, 1)) == 1) {
                this.physicalProcessorCount = this.logicalProcessorCount;
                break;
            }
            if (cpu.startsWith("cpu cores")) {
                cpucores = ParseUtil.parseLastInt(cpu, 1);
                if (siblings > 1) {
                    this.physicalProcessorCount = this.logicalProcessorCount * cpucores / siblings;
                    break;
                }
            }
            if (cpu.startsWith("core id") || cpu.startsWith("cpu number")) {
                uniqueID[0] = ParseUtil.parseLastInt(cpu, 0);
            } else if (cpu.startsWith("physical id")) {
                uniqueID[1] = ParseUtil.parseLastInt(cpu, 0);
            }
            if (uniqueID[0] < 0 || uniqueID[1] < 0) continue;
            ids.add(uniqueID[0] + " " + uniqueID[1]);
            uniqueID[0] = -1;
            uniqueID[1] = -1;
        }
        if (this.physicalProcessorCount == 0) {
            this.physicalProcessorCount = ids.size();
        }
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
        }
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
    }

    @Override
    public synchronized long[] getSystemCpuLoadTicks() {
        int i;
        long[] ticks = new long[this.curTicks.length];
        String tickStr = "";
        List<String> procStat = FileUtil.readFile("/proc/stat");
        if (procStat.isEmpty()) {
            return ticks;
        }
        tickStr = procStat.get(0);
        String[] tickArr = tickStr.split("\\s+");
        if (tickArr.length < 5) {
            return ticks;
        }
        for (i = 0; i < 4; ++i) {
            ticks[i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        if (tickArr.length > 5) {
            ticks[3] = ticks[3] + ParseUtil.parseLongOrDefault(tickArr[5], 0L);
            for (i = 6; i < tickArr.length; ++i) {
                ticks[2] = ticks[2] + ParseUtil.parseLongOrDefault(tickArr[i], 0L);
            }
        }
        return ticks;
    }

    @Override
    public long getSystemIOWaitTicks() {
        String tickStr = "";
        List<String> procStat = FileUtil.readFile("/proc/stat");
        if (procStat.isEmpty()) {
            return 0L;
        }
        tickStr = procStat.get(0);
        String[] tickArr = tickStr.split("\\s+");
        if (tickArr.length < 6) {
            return 0L;
        }
        return ParseUtil.parseLongOrDefault(tickArr[5], 0L);
    }

    @Override
    public long[] getSystemIrqTicks() {
        String tickStr = "";
        long[] ticks = new long[2];
        List<String> procStat = FileUtil.readFile("/proc/stat");
        if (procStat.isEmpty()) {
            return ticks;
        }
        tickStr = procStat.get(0);
        String[] tickArr = tickStr.split("\\s+");
        if (tickArr.length < 8) {
            return ticks;
        }
        ticks[0] = ParseUtil.parseLongOrDefault(tickArr[6], 0L);
        ticks[1] = ParseUtil.parseLongOrDefault(tickArr[7], 0L);
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        double[] average;
        int retval;
        if (nelem < 1) {
            throw new IllegalArgumentException("Must include at least one element.");
        }
        if (nelem > 3) {
            LOG.warn("Max elements of SystemLoadAverage is 3. " + nelem + " specified. Ignoring extra.");
            nelem = 3;
        }
        if ((retval = Libc.INSTANCE.getloadavg(average = new double[nelem], nelem)) < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][4];
        int cpu = 0;
        List<String> procStat = FileUtil.readFile("/proc/stat");
        for (String stat : procStat) {
            int i;
            if (!stat.startsWith("cpu") || stat.startsWith("cpu ")) continue;
            String[] tickArr = stat.split("\\s+");
            if (tickArr.length < 5) break;
            for (i = 0; i < 4; ++i) {
                ticks[cpu][i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
            }
            if (tickArr.length > 5) {
                long[] lArray = ticks[cpu];
                lArray[3] = lArray[3] + ParseUtil.parseLongOrDefault(tickArr[5], 0L);
                for (i = 6; i < tickArr.length; ++i) {
                    long[] lArray2 = ticks[cpu];
                    lArray2[2] = lArray2[2] + ParseUtil.parseLongOrDefault(tickArr[i], 0L);
                }
            }
            if (++cpu < this.logicalProcessorCount) continue;
            break;
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return (long)ProcUtil.getSystemUptimeFromProc();
    }

    @Override
    public String getSystemSerialNumber() {
        if (this.cpuSerialNumber == null) {
            ArrayList<String> hwInfo = ExecutingCommand.runNative("dmidecode -t system");
            String marker = "Serial Number:";
            if (hwInfo != null) {
                for (String checkLine : hwInfo) {
                    if (!checkLine.contains(marker)) continue;
                    this.cpuSerialNumber = checkLine.split(marker)[1].trim();
                    break;
                }
            }
            if (this.cpuSerialNumber == null) {
                marker = "system.hardware.serial =";
                hwInfo = ExecutingCommand.runNative("lshal");
                if (hwInfo != null) {
                    for (String checkLine : hwInfo) {
                        if (!checkLine.contains(marker)) continue;
                        String[] temp = checkLine.split(marker)[1].split("'");
                        this.cpuSerialNumber = temp.length > 0 ? temp[1] : null;
                        break;
                    }
                }
            }
            if (this.cpuSerialNumber == null) {
                this.cpuSerialNumber = "unknown";
            }
        }
        return this.cpuSerialNumber;
    }

    @Override
    public OSProcess[] getProcesses() {
        File[] pids;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (File pid : pids = ProcUtil.getPidFiles()) {
            OSProcess proc = this.getProcess(ParseUtil.parseIntOrDefault(pid.getName(), 0));
            if (proc == null) continue;
            procs.add(proc);
        }
        return procs.toArray(new OSProcess[procs.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        String[] split = FileUtil.getSplitFromFile(String.format("/proc/%d/stat", pid));
        if (split.length < 24) {
            return null;
        }
        String path = "";
        Memory buf = new Memory(1024L);
        int size = Libc.INSTANCE.readlink(String.format("/proc/%d/exe", pid), buf, 1023);
        if (size > 0) {
            path = buf.getString(0L).substring(0, size);
        }
        return new LinuxProcess(split[1].replaceFirst("\\(", "").replace(")", ""), path, split[2].charAt(0), pid, ParseUtil.parseIntOrDefault(split[3], 0), ParseUtil.parseIntOrDefault(split[19], 0), ParseUtil.parseIntOrDefault(split[17], 0), ParseUtil.parseLongOrDefault(split[22], 0L), ParseUtil.parseLongOrDefault(split[23], 0L), ParseUtil.parseLongOrDefault(split[14], 0L), ParseUtil.parseLongOrDefault(split[13], 0L), ParseUtil.parseLongOrDefault(split[21], 0L), System.currentTimeMillis());
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcUtil.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        try {
            Libc.Sysinfo info = new Libc.Sysinfo();
            if (0 != Libc.INSTANCE.sysinfo(info)) {
                LOG.error("Failed to get process thread count. Error code: " + Native.getLastError());
                return 0;
            }
            return info.procs;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            LOG.error("Failed to get procs from sysinfo. {}", (Object)e.getMessage());
            return 0;
        }
    }
}

