/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.hardware.Display;
import oshi.hardware.common.AbstractDisplay;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public class LinuxDisplay
extends AbstractDisplay {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxDisplay.class);

    public LinuxDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized LinuxDisplay");
    }

    public static Display[] getDisplays() {
        ArrayList<LinuxDisplay> displays = new ArrayList<LinuxDisplay>();
        ArrayList<String> xrandr = ExecutingCommand.runNative("xrandr --verbose");
        if (xrandr != null) {
            boolean foundEdid = false;
            StringBuilder sb = new StringBuilder();
            for (String s : xrandr) {
                if (s.contains("EDID")) {
                    foundEdid = true;
                    sb = new StringBuilder();
                    continue;
                }
                if (!foundEdid) continue;
                sb.append(s.trim());
                if (sb.length() < 256) continue;
                String edidStr = sb.toString();
                LOG.debug("Parsed EDID: {}", (Object)edidStr);
                byte[] edid = ParseUtil.hexStringToByteArray(edidStr);
                if (edid != null) {
                    displays.add(new LinuxDisplay(edid));
                }
                foundEdid = false;
            }
        }
        return displays.toArray(new Display[displays.size()]);
    }
}

