/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;

public class ExecutingCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutingCommand.class);

    public static ArrayList<String> runNative(String cmdToRun) {
        String[] cmd = cmdToRun.split(" ");
        return ExecutingCommand.runNative(cmd);
    }

    public static ArrayList<String> runNative(String[] cmdToRunWithArgs) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdToRunWithArgs);
        }
        catch (IOException e) {
            LOG.trace("", e);
            return null;
        }
        ArrayList<String> sa = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sa.add(line);
            }
            p.waitFor();
        }
        catch (InterruptedException e) {
            LOG.trace("", e);
            return null;
        }
        catch (IOException e) {
            LOG.trace("", e);
            return null;
        }
        return sa;
    }

    public static String getFirstAnswer(String cmd2launch) {
        return ExecutingCommand.getAnswerAt(cmd2launch, 0);
    }

    public static String getAnswerAt(String cmd2launch, int answerIdx) {
        ArrayList<String> sa = ExecutingCommand.runNative(cmd2launch);
        if (sa != null && answerIdx >= 0 && answerIdx < sa.size()) {
            return (String)sa.get(answerIdx);
        }
        return null;
    }
}

