/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.StringWriter;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.shaded.json.Json;
import javax.shaded.json.JsonObject;
import javax.shaded.json.JsonWriter;
import javax.shaded.json.JsonWriterFactory;
import javax.xml.bind.DatatypeConverter;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;

public abstract class ParseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ParseUtil.class);
    private static final String Hertz = "Hz";
    private static final String kiloHertz = "kHz";
    private static final String megaHertz = "MHz";
    private static final String gigaHertz = "GHz";
    private static final String teraHertz = "THz";
    private static final String petaHertz = "PHz";
    private static final Map<String, Long> multipliers = new HashMap<String, Long>();
    private static final Pattern HERTZ;
    private static final Pattern VALID_HEX;
    private static DateTimeFormatter CIM_FORMAT;

    public static long parseHertz(String hertz) {
        Matcher matcher = HERTZ.matcher(hertz.trim());
        if (matcher.find() && matcher.groupCount() == 3) {
            try {
                Double value = Double.valueOf(matcher.group(1)) * (double)multipliers.getOrDefault(matcher.group(3), -1L).longValue();
                return value < 0.0 ? -1L : value.longValue();
            }
            catch (NumberFormatException e) {
                LOG.trace("", e);
            }
        }
        return -1L;
    }

    public static int parseLastInt(String s, int i) {
        String[] ss = s.split("\\s+");
        if (ss.length < 2) {
            return i;
        }
        try {
            return Integer.parseInt(ss[ss.length - 1]);
        }
        catch (NumberFormatException nfe) {
            return i;
        }
    }

    public static byte[] hexStringToByteArray(String digits) {
        if (!VALID_HEX.matcher(digits).matches()) {
            LOG.error("Invalid hexadecimal string: {}", (Object)digits);
            return null;
        }
        int len = digits.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)(Character.digit(digits.charAt(i), 16) << 4 | Character.digit(digits.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] stringToByteArray(String text, int length) {
        return Arrays.copyOf(text.getBytes(), length);
    }

    public static byte[] longToByteArray(long value, int valueSize, int length) {
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value != 0L; value >>>= 8, --i) {
            b[i] = (byte)value;
        }
        return Arrays.copyOfRange(b, 8 - valueSize, 8 + length - valueSize);
    }

    public static long strToLong(String str, int size) {
        return ParseUtil.byteArrayToLong(str.getBytes(), size);
    }

    public static long byteArrayToLong(byte[] bytes, int size) {
        if (size > 8) {
            throw new IllegalArgumentException("Can't convert more than 8 bytes.");
        }
        if (size > bytes.length) {
            throw new IllegalArgumentException("Size can't be larger than array length.");
        }
        long total = 0L;
        for (int i = 0; i < size; ++i) {
            total = total << 8 | (long)(bytes[i] & 0xFF);
        }
        return total;
    }

    public static float byteArrayToFloat(byte[] bytes, int size, int fpBits) {
        return (float)ParseUtil.byteArrayToLong(bytes, size) / (float)(1 << fpBits);
    }

    public static String jsonPrettyPrint(JsonObject json) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.shaded.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        JsonWriter jsonWriter = writerFactory.createWriter(stringWriter);
        jsonWriter.write(json);
        jsonWriter.close();
        return stringWriter.toString();
    }

    public static long cimDateTimeToMillis(String cimDate) {
        try {
            int tzInMinutes = Integer.parseInt(cimDate.substring(22));
            LocalTime offsetAsLocalTime = LocalTime.MIN.plusMinutes(tzInMinutes);
            OffsetDateTime dateTime = OffsetDateTime.parse(cimDate.substring(0, 22) + offsetAsLocalTime.format(DateTimeFormatter.ISO_LOCAL_TIME), CIM_FORMAT);
            return dateTime.toInstant().toEpochMilli();
        }
        catch (IndexOutOfBoundsException | NumberFormatException | DateTimeParseException e) {
            return 0L;
        }
    }

    public static String hexStringToString(String hexString) {
        try {
            return new String(DatatypeConverter.parseHexBinary((String)hexString));
        }
        catch (IllegalArgumentException e) {
            return hexString;
        }
    }

    public static int parseIntOrDefault(String s, int defaultInt) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultInt;
        }
    }

    public static long parseLongOrDefault(String s, long defaultLong) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultLong;
        }
    }

    static {
        multipliers.put(Hertz, 1L);
        multipliers.put(kiloHertz, 1000L);
        multipliers.put(megaHertz, 1000000L);
        multipliers.put(gigaHertz, 1000000000L);
        multipliers.put(teraHertz, 1000000000000L);
        multipliers.put(petaHertz, 1000000000000000L);
        HERTZ = Pattern.compile("(\\d+(.\\d+)?) ?([kMGT]?Hz)");
        VALID_HEX = Pattern.compile("[0-9a-fA-F]+");
        CIM_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSSSSSZZZZZ", Locale.US);
    }
}

