/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.jms.management.JMSServerControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueAdd;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class JMSQueueRemove
extends AbstractRemoveStepHandler {
    static final JMSQueueRemove INSTANCE = new JMSQueueRemove();

    private JMSQueueRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName binderServiceName;
        ContextNames.BindInfo bindInfo;
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
        JMSServerControl control = (JMSServerControl)JMSServerControl.class.cast(server.getManagementService().getResource("jms.server"));
        if (control != null) {
            try {
                control.destroyQueue(name, true);
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        context.removeService(JMSServices.getJmsQueueBaseServiceName(serviceName).append(new String[]{name}));
        for (String entry : CommonAttributes.DESTINATION_ENTRIES.unwrap((ExpressionResolver)context, model)) {
            bindInfo = ContextNames.bindInfoFor((String)entry);
            binderServiceName = bindInfo.getBinderServiceName();
            context.removeService(binderServiceName);
        }
        for (String legacyEntry : CommonAttributes.LEGACY_ENTRIES.unwrap((ExpressionResolver)context, model)) {
            bindInfo = ContextNames.bindInfoFor((String)legacyEntry);
            binderServiceName = bindInfo.getBinderServiceName();
            context.removeService(binderServiceName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        JMSQueueAdd.INSTANCE.performRuntime(context, operation, model);
    }
}

