/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection;

import java.io.Serializable;
import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Element;

public final class ThreadLocalAwareWebServiceContext
implements WebServiceContext,
Serializable {
    private static final long serialVersionUID = 126557512266764152L;
    private static final ThreadLocalAwareWebServiceContext SINGLETON = new ThreadLocalAwareWebServiceContext();
    private final transient ThreadLocal<WebServiceContext> contexts = new InheritableThreadLocal<WebServiceContext>();

    public static ThreadLocalAwareWebServiceContext getInstance() {
        return SINGLETON;
    }

    public void setMessageContext(WebServiceContext ctx) {
        this.contexts.set(ctx);
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getWebServiceContext().getEndpointReference(referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        return (T)this.getWebServiceContext().getEndpointReference(clazz, referenceParameters);
    }

    public MessageContext getMessageContext() {
        return this.getWebServiceContext().getMessageContext();
    }

    public Principal getUserPrincipal() {
        return this.getWebServiceContext().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getWebServiceContext().isUserInRole(role);
    }

    private WebServiceContext getWebServiceContext() {
        WebServiceContext delegate = this.contexts.get();
        if (delegate == null) {
            throw new IllegalStateException();
        }
        return delegate;
    }

    protected Object readResolve() {
        return SINGLETON;
    }
}

