/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.appclient.parser.jboss;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.appclient.jboss.JBossClientMetaData;
import org.jboss.metadata.appclient.parser.jboss.JBossClientElement;
import org.jboss.metadata.appclient.parser.spec.ApplicationClientMetaDataParser;
import org.jboss.metadata.appclient.spec.AppClientEnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

public class JBossClientMetaDataParser
extends ApplicationClientMetaDataParser {
    public static final JBossClientMetaDataParser INSTANCE = new JBossClientMetaDataParser();

    @Override
    public JBossClientMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return this.parse(reader, PropertyReplacers.noop());
    }

    @Override
    public JBossClientMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
        JBossClientMetaData metaData = new JBossClientMetaData();
        metaData.setDescriptionGroup(new DescriptionGroupMetaData());
        metaData.setEnvironmentRefsGroupMetaData(new AppClientEnvironmentRefsGroupMetaData());
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (JBossClientMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            this.processAttribute(metaData, reader, i);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.processElement(metaData, reader, propertyReplacer);
        }
        return metaData;
    }

    protected void processElement(JBossClientMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        JBossClientElement element = JBossClientElement.forName(reader.getLocalName());
        switch (element) {
            case DEPENDS: {
                if (metaData.getDepends() == null) {
                    metaData.setDepends(new ArrayList<String>());
                }
                metaData.getDepends().add(JBossClientMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case JNDI_NAME: {
                metaData.setJndiName(JBossClientMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case METADATA_COMPLETE: {
                metaData.setMetadataComplete(Boolean.parseBoolean(JBossClientMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                break;
            }
            default: {
                super.processElement(metaData, reader, propertyReplacer);
            }
        }
    }
}

