/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.CacheBuilderFactory;
import org.wildfly.clustering.server.registry.RegistryBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupBuilderProvider;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class RegistryFactoryBuilderProvider
implements CacheGroupBuilderProvider {
    private final CacheBuilderFactory<RegistryFactory<Object, Object>> factory;

    public RegistryFactoryBuilderProvider(CacheBuilderFactory<RegistryFactory<Object, Object>> factory) {
        this.factory = factory;
    }

    public Collection<Builder<?>> getBuilders(String containerName, String cacheName) {
        Builder<RegistryFactory<Object, Object>> builder = this.factory.createBuilder(containerName, cacheName);
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", CacheGroupServiceName.REGISTRY.toString(), containerName, cacheName}).getAbsoluteName());
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(binding, builder.getServiceName(), RegistryFactory.class);
        RegistryBuilder registryBuilder = new RegistryBuilder(containerName, cacheName);
        return Arrays.asList(builder, bindingBuilder, registryBuilder);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

