/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class DisconnectMessage
extends PacketImpl {
    private SimpleString nodeID;

    public DisconnectMessage(SimpleString nodeID) {
        super((byte)11);
        this.nodeID = nodeID;
    }

    public DisconnectMessage() {
        super((byte)11);
    }

    public SimpleString getNodeID() {
        return this.nodeID;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeNullableSimpleString(this.nodeID);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.nodeID = buffer.readNullableSimpleString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.getParentString());
        buf.append(", nodeID=" + this.nodeID);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DisconnectMessage)) {
            return false;
        }
        DisconnectMessage other = (DisconnectMessage)obj;
        return !(this.nodeID == null ? other.nodeID != null : !this.nodeID.equals((Object)other.nodeID));
    }
}

