/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.SyncModelOperationHandlerWrapper;
import org.jboss.as.domain.controller.operations.coordination.DomainControllerLockIdUtils;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.MultiPhaseLocalContext;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationsResolverHandler;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;

class OperationSlaveStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final Map<String, ProxyController> serverProxies;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final ExtensionRegistry extensionRegistry;

    OperationSlaveStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> serverProxies, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, ExtensionRegistry extensionRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.serverProxies = serverProxies;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.extensionRegistry = extensionRegistry;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        MultiPhaseLocalContext localContext;
        HostControllerExecutionSupport hostControllerExecutionSupport;
        boolean reloadRequired;
        ModelNode headers = operation.get("operation-headers");
        headers.remove("execute-for-coordinator");
        if (headers.hasDefined("domain-controller-lock-id")) {
            int id = headers.remove("domain-controller-lock-id").asInt();
            context.attach(DomainControllerLockIdUtils.DOMAIN_CONTROLLER_LOCK_ID_ATTACHMENT, (Object)id);
        }
        if (reloadRequired = (hostControllerExecutionSupport = this.addSteps(context, operation, localContext = new MultiPhaseLocalContext(false))).isReloadRequired()) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                hostControllerExecutionSupport.complete(resultAction == OperationContext.ResultAction.ROLLBACK);
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    ModelNode result = context.getResult();
                    result.setEmptyObject();
                    ModelNode domainFormatted = hostControllerExecutionSupport.getFormattedDomainResult(localContext.getLocalResponse().get("result"));
                    result.get("domain-results").set(domainFormatted);
                } else {
                    if (reloadRequired) {
                        context.revertReloadRequired();
                    }
                    if (hostControllerExecutionSupport.getDomainOperation() != null) {
                        ModelNode localResponse = localContext.getLocalResponse();
                        if (localResponse.has("failure-description")) {
                            context.getFailureDescription().set(localResponse.get("failure-description"));
                        }
                        if (localResponse.has("result")) {
                            context.getResult().set(localResponse.get("result"));
                        }
                    }
                }
            }
        });
    }

    HostControllerExecutionSupport addSteps(OperationContext context, ModelNode operation, MultiPhaseLocalContext multiPhaseLocalContext) throws OperationFailedException {
        PathAddress originalAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ImmutableManagementResourceRegistration originalRegistration = context.getResourceRegistration();
        ModelNode localResponse = multiPhaseLocalContext.getLocalResponse();
        HostControllerExecutionSupport hostControllerExecutionSupport = HostControllerExecutionSupport.Factory.create(context, operation, this.localHostControllerInfo.getLocalHostName(), new LazyDomainModelProvider(context), this.ignoredDomainResourceRegistry, !this.localHostControllerInfo.isMasterDomainController() && this.localHostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration(), this.extensionRegistry);
        ModelNode domainOp = hostControllerExecutionSupport.getDomainOperation();
        if (domainOp != null) {
            if (originalRegistration == null) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(originalAddress));
            }
            this.addBasicStep(context, domainOp, localResponse);
        }
        ServerOperationResolver resolver = new ServerOperationResolver(this.localHostControllerInfo.getLocalHostName(), this.serverProxies);
        ServerOperationsResolverHandler sorh = new ServerOperationsResolverHandler(resolver, hostControllerExecutionSupport, originalAddress, originalRegistration, multiPhaseLocalContext);
        context.addStep((OperationStepHandler)sorh, OperationContext.Stage.DOMAIN);
        return hostControllerExecutionSupport;
    }

    private void addBasicStep(OperationContext context, ModelNode operation, ModelNode localReponse) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        OperationEntry entry = context.getRootResourceRegistration().getOperationEntry(PathAddress.pathAddress((ModelNode)operation.get("address")), operationName);
        if (entry != null) {
            if (context.isBooting() || this.localHostControllerInfo.isMasterDomainController()) {
                context.addStep(localReponse, operation, entry.getOperationHandler(), OperationContext.Stage.MODEL);
            } else {
                OperationStepHandler wrapper;
                if (this.localHostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration()) {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    wrapper = SyncModelOperationHandlerWrapper.wrapHandler(this.localHostControllerInfo.getLocalHostName(), operationName, address, entry);
                } else {
                    wrapper = entry.getOperationHandler();
                }
                context.addStep(localReponse, operation, wrapper, OperationContext.Stage.MODEL);
            }
        } else {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, PathAddress.pathAddress((ModelNode)operation.get("address"))));
        }
    }

    private static class LazyDomainModelProvider
    implements HostControllerExecutionSupport.DomainModelProvider {
        private final OperationContext context;
        private Resource domainModelResource;

        private LazyDomainModelProvider(OperationContext context) {
            this.context = context;
        }

        @Override
        public Resource getDomainModel() {
            if (this.domainModelResource == null) {
                this.domainModelResource = this.context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true);
            }
            return this.domainModelResource;
        }
    }
}

