/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.AnonymousCallbackHandler;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemotingConnectionClusterNodeManager
implements ClusterNodeManager {
    private final String nodeName;
    private final ClusterContext clusterContext;
    private final String destinationHost;
    private final int destinationPort;
    private final String destinationProtocol;
    private final Endpoint endpoint;

    RemotingConnectionClusterNodeManager(ClusterContext clusterContext, Endpoint endpoint, String nodeName, String destinationHost, int destinationPort, String destinationProtocol) {
        this.nodeName = nodeName;
        this.clusterContext = clusterContext;
        this.destinationHost = destinationHost;
        this.destinationPort = destinationPort;
        this.endpoint = endpoint;
        this.destinationProtocol = destinationProtocol;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public EJBReceiver getEJBReceiver() {
        ClusterNodeReconnectHandler reconnectHandler;
        Connection connection;
        OptionMap channelCreationOptions = OptionMap.EMPTY;
        EJBClientConfiguration ejbClientConfiguration = this.clusterContext.getEJBClientContext().getEJBClientConfiguration();
        try {
            if (ejbClientConfiguration != null) {
                EJBClientConfiguration.ClusterConfiguration clusterConfiguration = ejbClientConfiguration.getClusterConfiguration(this.clusterContext.getClusterName());
                if (clusterConfiguration == null) {
                    OptionMap connectionCreationOptions = OptionMap.EMPTY;
                    CallbackHandler callbackHandler = ejbClientConfiguration.getCallbackHandler();
                    IoFuture futureConnection = NetworkUtil.connect((Endpoint)this.endpoint, (String)this.destinationProtocol, (String)this.destinationHost, (int)this.destinationPort, null, (OptionMap)connectionCreationOptions, (CallbackHandler)callbackHandler, null);
                    connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    reconnectHandler = new ClusterNodeReconnectHandler(this.destinationHost, this.destinationPort, connectionCreationOptions, callbackHandler, channelCreationOptions, 5000L);
                } else {
                    EJBClientConfiguration.ClusterNodeConfiguration clusterNodeConfiguration = clusterConfiguration.getNodeConfiguration(this.getNodeName());
                    channelCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getChannelCreationOptions() : clusterNodeConfiguration.getChannelCreationOptions();
                    OptionMap connectionCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionCreationOptions() : clusterNodeConfiguration.getConnectionCreationOptions();
                    CallbackHandler callbackHandler = clusterNodeConfiguration == null ? clusterConfiguration.getCallbackHandler() : clusterNodeConfiguration.getCallbackHandler();
                    IoFuture futureConnection = NetworkUtil.connect((Endpoint)this.endpoint, (String)this.destinationProtocol, (String)this.destinationHost, (int)this.destinationPort, null, (OptionMap)connectionCreationOptions, (CallbackHandler)callbackHandler, null);
                    long timeout = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionTimeout() : clusterNodeConfiguration.getConnectionTimeout();
                    connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
                    reconnectHandler = new ClusterNodeReconnectHandler(this.destinationHost, this.destinationPort, connectionCreationOptions, callbackHandler, channelCreationOptions, timeout);
                }
            } else {
                OptionMap connectionCreationOptions = OptionMap.EMPTY;
                AnonymousCallbackHandler callbackHandler = new AnonymousCallbackHandler();
                IoFuture futureConnection = NetworkUtil.connect((Endpoint)this.endpoint, (String)this.destinationProtocol, (String)this.destinationHost, (int)this.destinationPort, null, (OptionMap)connectionCreationOptions, (CallbackHandler)callbackHandler, null);
                connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                reconnectHandler = new ClusterNodeReconnectHandler(this.destinationHost, this.destinationPort, connectionCreationOptions, callbackHandler, channelCreationOptions, 5000L);
            }
        }
        catch (Exception e) {
            EjbLogger.REMOTE_LOGGER.couldNotCreateClusterConnection(e, this.nodeName, this.clusterContext.getClusterName());
            return null;
        }
        return new RemotingConnectionEJBReceiver(connection, (ReconnectHandler)reconnectHandler, channelCreationOptions, this.destinationProtocol);
    }

    private class ClusterNodeReconnectHandler
    implements ReconnectHandler {
        private final String destinationHost;
        private final int destinationPort;
        private final OptionMap connectionCreationOptions;
        private final OptionMap channelCreationOptions;
        private final CallbackHandler callbackHandler;
        private final long connectionTimeout;

        ClusterNodeReconnectHandler(String host, int port, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, OptionMap channelCreationOptions, long connectionTimeoutInMillis) {
            this.destinationHost = host;
            this.destinationPort = port;
            this.connectionCreationOptions = connectionCreationOptions;
            this.channelCreationOptions = channelCreationOptions;
            this.callbackHandler = callbackHandler;
            this.connectionTimeout = connectionTimeoutInMillis;
        }

        public void reconnect() throws IOException {
            Connection connection = null;
            try {
                IoFuture futureConnection = NetworkUtil.connect((Endpoint)RemotingConnectionClusterNodeManager.this.endpoint, (String)"remote", (String)this.destinationHost, (int)this.destinationPort, null, (OptionMap)this.connectionCreationOptions, (CallbackHandler)this.callbackHandler, null);
                connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)this.connectionTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
                EjbLogger.REMOTE_LOGGER.debugf("Successfully reconnected to connection %s", connection);
            }
            catch (Exception e) {
                EjbLogger.REMOTE_LOGGER.debugf(e, "Failed to re-connect to %s:%d", this.destinationHost, this.destinationPort);
            }
            if (connection == null) {
                return;
            }
            try {
                RemotingConnectionEJBReceiver ejbReceiver = new RemotingConnectionEJBReceiver(connection, (ReconnectHandler)this, this.channelCreationOptions, "remote");
                RemotingConnectionClusterNodeManager.this.clusterContext.registerEJBReceiver((EJBReceiver)ejbReceiver);
            }
            finally {
                RemotingConnectionClusterNodeManager.this.clusterContext.getEJBClientContext().unregisterReconnectHandler((ReconnectHandler)this);
            }
        }
    }
}

