/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class JaxrsSpringProcessor
implements DeploymentUnitProcessor {
    private static final String JAR_LOCATION = "resteasy-spring-jar";
    private static final ModuleIdentifier MODULE = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-spring");
    public static final String SPRING_LISTENER = "org.jboss.resteasy.plugins.spring.SpringContextLoaderListener";
    public static final String SPRING_SERVLET = "org.springframework.web.servlet.DispatcherServlet";
    @Deprecated
    public static final String DISABLE_PROPERTY = "org.jboss.as.jaxrs.disableSpringIntegration";
    public static final String ENABLE_PROPERTY = "org.jboss.as.jaxrs.enableSpringIntegration";
    public static final String SERVICE_NAME = "resteasy-spring-integration-resource-root";
    private final ServiceTarget serviceTarget;
    private VirtualFile resourceRoot;

    public JaxrsSpringProcessor(ServiceTarget serviceTarget) {
        this.serviceTarget = serviceTarget;
    }

    protected synchronized VirtualFile getResteasySpringVirtualFile() throws DeploymentUnitProcessingException {
        if (this.resourceRoot != null) {
            return this.resourceRoot;
        }
        try {
            Module module = Module.getBootModuleLoader().loadModule(MODULE);
            URL fileUrl = module.getClassLoader().getResource(JAR_LOCATION);
            if (fileUrl == null) {
                throw JaxrsLogger.JAXRS_LOGGER.noSpringIntegrationJar();
            }
            File dir = new File(fileUrl.toURI());
            File file = null;
            for (String jar : dir.list()) {
                if (!jar.endsWith(".jar")) continue;
                file = new File(dir, jar);
                break;
            }
            if (file == null) {
                throw JaxrsLogger.JAXRS_LOGGER.noSpringIntegrationJar();
            }
            VirtualFile vf = VFS.getChild((URI)file.toURI());
            final Closeable mountHandle = VFS.mountZip((File)file, (VirtualFile)vf, (TempFileProvider)TempFileProviderService.provider());
            Service<Closeable> mountHandleService = new Service<Closeable>(){

                public void start(StartContext startContext) throws StartException {
                }

                public void stop(StopContext stopContext) {
                    VFSUtils.safeClose((Closeable)mountHandle);
                }

                public Closeable getValue() throws IllegalStateException, IllegalArgumentException {
                    return mountHandle;
                }
            };
            ServiceBuilder builder = this.serviceTarget.addService(ServiceName.JBOSS.append(new String[]{SERVICE_NAME}), (Service)mountHandleService);
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            this.resourceRoot = vf;
            return this.resourceRoot;
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ArrayList<DeploymentUnit> deploymentUnits = new ArrayList<DeploymentUnit>();
        deploymentUnits.add(deploymentUnit);
        deploymentUnits.addAll(deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS));
        boolean found = false;
        for (DeploymentUnit unit : deploymentUnits) {
            JBossWebMetaData md;
            WarMetaData warMetaData = (WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            if (warMetaData == null || (md = warMetaData.getMergedJBossWebMetaData()) == null) continue;
            if (md.getContextParams() != null) {
                boolean skip = false;
                for (ParamValueMetaData prop : md.getContextParams()) {
                    if (prop.getParamName().equals(ENABLE_PROPERTY)) {
                        boolean explicitEnable = Boolean.parseBoolean(prop.getParamValue());
                        if (explicitEnable) {
                            found = true;
                            break;
                        }
                        skip = true;
                        break;
                    }
                    if (!prop.getParamName().equals(DISABLE_PROPERTY) || !"true".equals(prop.getParamValue())) continue;
                    skip = true;
                    JaxrsLogger.JAXRS_LOGGER.disablePropertyDeprecated();
                    break;
                }
                if (skip) continue;
            }
            if (md.getListeners() != null) {
                for (ListenerMetaData listener : md.getListeners()) {
                    if (!SPRING_LISTENER.equals(listener.getListenerClass())) continue;
                    found = true;
                    break;
                }
            }
            if (md.getServlets() != null) {
                for (JBossServletMetaData servlet : md.getServlets()) {
                    if (!SPRING_SERVLET.equals(servlet.getServletClass())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            try {
                MountHandle mh = new MountHandle(null);
                ResourceRoot resourceRoot = new ResourceRoot(this.getResteasySpringVirtualFile(), mh);
                ModuleRootMarker.mark((ResourceRoot)resourceRoot);
                deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)resourceRoot);
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            return;
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

